/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular;

import com.google.common.collect.ImmutableMultimap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import tv.soaryn.xycraft.machines.content.items.modular.IModuleStorage;

public interface IModule {
    public static final Rarity BaseRarity = Rarity.create((String)"xycraft.base", style -> style.m_178520_(0xFFFFFF));
    public static final Rarity ImprovedRarity = Rarity.create((String)"xycraft.improved", style -> style.m_178520_(0x99AAFF));
    public static final Rarity SpecializationRarity = Rarity.create((String)"xycraft.specialization", style -> style.m_178520_(0xFFEE77));
    public static final Rarity MythicRarity = Rarity.create((String)"xycraft.mythic", style -> style.m_178520_(0xCC66DD));

    default public void onAddTo(ItemStack stack) {
    }

    default public void onRemoveFrom(ItemStack stack) {
    }

    public boolean isModuleFor(ItemStack var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isValidFor(ItemStack stack) {
        if (!this.isModuleFor(stack)) return false;
        if (!IModuleStorage.getInstalledModules(stack).noneMatch(Mythic.class::isInstance)) return false;
        return true;
    }

    default public void tick(ItemStack stack, Level level, Player player) {
    }

    default public void addsAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, EquipmentSlot slot, ItemStack stack) {
    }

    public static IModule getIModuleFrom(Tag tag) {
        return IModule.getIModuleFrom(IModule.getModuleStackFrom(tag));
    }

    public static ItemStack getModuleStackFrom(Tag tag) {
        return ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
    }

    public static IModule getIModuleFrom(ItemStack stack) {
        IModule module;
        Item item = stack.m_41720_();
        return item instanceof IModule ? (module = (IModule)item) : null;
    }

    public static interface Mythic
    extends IModule {
        @Override
        default public boolean isValidFor(ItemStack stack) {
            return this.isModuleFor(stack) && IModuleStorage.getInstalledModules(stack).findAny().isEmpty();
        }
    }

    public static interface Specialized
    extends IModule {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        default public boolean isValidFor(ItemStack stack) {
            if (!IModule.super.isValidFor(stack)) return false;
            if (!this.isModuleFor(stack)) return false;
            if (!IModuleStorage.getInstalledModules(stack).noneMatch(Specialized.class::isInstance)) return false;
            return true;
        }
    }
}

