/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.imc.IMCRegistries;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.items.modular.IModule;
import tv.soaryn.xycraft.machines.content.items.modular.IModuleStorage;
import tv.soaryn.xycraft.machines.content.items.modular.modules.ArchonEnergyModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.EnchantmentModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.EnergyEfficiencyModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.mining.AreaModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.mining.EnvironmentalModule;
import tv.soaryn.xycraft.machines.content.items.modular.modules.mining.MiningSpeedModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.mining.TunnelerModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.mining.VeinMineModuleItem;
import tv.soaryn.xycraft.machines.network.CBFreezeBlockPacket;
import tv.soaryn.xycraft.machines.utils.AreaUtils;
import tv.soaryn.xycraft.machines.utils.EnergyUtils;

public class GauntletItem
extends XyItem
implements IModuleStorage {
    private final Tier _tier;
    private final String KEY_ACTIVE = "module.active";
    private static final Set<ToolAction> _validTools = (Set)Util.m_137537_(() -> {
        HashSet actions = new HashSet();
        actions.addAll(ToolActions.DEFAULT_AXE_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_HOE_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_PICKAXE_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_SHOVEL_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_SWORD_ACTIONS);
        actions.addAll(ToolActions.DEFAULT_SHEARS_ACTIONS);
        return ImmutableSet.copyOf(actions);
    });

    public GauntletItem(Tier tier) {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_246768_(new FeatureFlag[]{FeatureFlags.f_244112_}));
        this._tier = tier;
    }

    public static Item iron() {
        return new GauntletItem((Tier)Tiers.IRON);
    }

    public static Item diamond() {
        return new GauntletItem((Tier)Tiers.DIAMOND);
    }

    public static Item netherite() {
        return new GauntletItem((Tier)Tiers.NETHERITE);
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        Stream<ItemStack> modules = IModuleStorage.getInstalledModuleStacks(stack);
        List<Rarity> rarities = modules.map(ItemStack::m_41791_).toList();
        if (rarities.contains(IModule.MythicRarity)) {
            return IModule.MythicRarity;
        }
        if (rarities.contains(IModule.SpecializationRarity)) {
            return IModule.SpecializationRarity;
        }
        if (rarities.contains(IModule.ImprovedRarity)) {
            return IModule.ImprovedRarity;
        }
        return IModule.BaseRarity;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, components, tooltipFlag);
        Stream<ItemStack> modules = IModuleStorage.getInstalledModuleStacks(stack);
        List<ItemStack> installedList = modules.toList();
        for (ItemStack itemStack : installedList) {
            Item item = itemStack.m_41720_();
            int tempColor = 0xAAAAAA;
            Rarity rarity = item.m_41460_(itemStack);
            if (rarity == IModule.MythicRarity) {
                tempColor = 0x8866AA;
            } else if (rarity == IModule.SpecializationRarity) {
                tempColor = 0xBBAA66;
            } else if (rarity == IModule.ImprovedRarity) {
                tempColor = 0x99AACC;
            }
            components.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)itemStack.m_41611_().m_6881_().m_130948_(Style.f_131099_.m_178520_(tempColor))));
        }
        if (tooltipFlag.m_7050_()) {
            Map<Enchantment, Integer> enchantmentMap = this.getAllEnchantments(stack);
            for (Map.Entry<Enchantment, Integer> enchantmentIntegerEntry : enchantmentMap.entrySet()) {
                components.add((Component)Component.m_237113_((String)"  Pseudo-").m_130948_(Style.f_131099_.m_178520_(-10066330)).m_7220_((Component)enchantmentIntegerEntry.getKey().m_44700_(enchantmentIntegerEntry.getValue().intValue()).m_6881_().m_130948_(Style.f_131099_.m_178520_(-10066330))));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41784_();
            if (!level.m_5776_()) {
                tag.m_128379_("module.active", !tag.m_128471_("module.active"));
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("module.active");
    }

    public ArrayList<BlockPos> getAffectedBlocks(ItemStack stack, LevelReader level, BlockPos origin, Direction dir) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        if (IModuleStorage.isInstalled(VeinMineModuleItem.class, stack) && this.isActive(stack)) {
            BlockState originState = level.m_8055_(origin);
            BlockPos.m_276833_((BlockPos)origin, (int)2, (int)12, GauntletEvents::iterateBreadthSearch, pos -> GauntletEvents.matchesVein(level, origin, blockPositions, originState, pos));
        } else {
            int radius = this.getRadius(stack);
            if (radius == 0) {
                return blockPositions;
            }
            int offset = -radius + 1;
            blockPositions.addAll(AreaUtils.getFromRadius(origin.m_6630_(0), dir, radius, offset).filter(Predicate.not(arg_0 -> ((BlockPos)origin).equals(arg_0))).toList());
        }
        blockPositions.removeIf(pos -> !this.isCorrectToolForDrops(stack, level.m_8055_(pos)));
        return blockPositions;
    }

    public int getRadius(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128471_("module.active") ? tag.m_128451_("module.radius") : 0;
    }

    public int energyRequired(Player player, ItemStack stack, boolean baseCost) {
        if (player.m_150110_().f_35937_) {
            return 0;
        }
        int energyEfficiencyCount = EnergyEfficiencyModuleItem.energyEfficiencyOf(stack);
        if (!baseCost && IModuleStorage.isInstalled(ArchonEnergyModuleItem.class, stack)) {
            float randValue = (float)player.m_217043_().m_188503_(100) * 0.01f;
            float threshold = 0.1f + (float)energyEfficiencyCount * 0.1f;
            if (!player.m_9236_().m_5776_() && randValue < threshold) {
                return 0;
            }
        }
        return 4 - energyEfficiencyCount;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return _validTools.contains(toolAction);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        if (context.m_43723_() == null) {
            return super.m_6225_(context);
        }
        ArrayList<BlockPos> blocks = this.getAffectedBlocks(context.m_43722_(), (LevelReader)context.m_43725_(), context.m_8083_(), context.m_43719_());
        InteractionResult target = this.axeAction(context);
        if (target == InteractionResult.PASS) {
            target = ModifierKeyCapability.of((Player)context.m_43723_()) ? this.shovelAction(context) : this.hoeAction(context);
        }
        for (BlockPos pos : blocks) {
            UseOnContext useContext = new UseOnContext(context.m_43723_(), context.m_43724_(), new BlockHitResult(context.m_43720_().m_82492_((double)context.m_8083_().m_123341_(), (double)context.m_8083_().m_123342_(), (double)context.m_8083_().m_123343_()).m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), context.m_43719_(), pos, false));
            InteractionResult temp = this.axeAction(useContext);
            if (temp == InteractionResult.PASS) {
                temp = ModifierKeyCapability.of((Player)useContext.m_43723_()) ? this.shovelAction(useContext) : this.hoeAction(useContext);
            }
            if (temp == InteractionResult.PASS || target != InteractionResult.PASS) continue;
            target = temp;
        }
        if (target != InteractionResult.PASS) {
            return target;
        }
        return super.m_6225_(context);
    }

    public InteractionResult axeAction(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false));
        ItemStack itemstack = context.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_46597_(blockpos, (BlockState)optional3.get());
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)optional3.get())));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult shovelAction(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        BlockState modifiedState = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
        BlockState resultState = null;
        if (modifiedState != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            resultState = modifiedState;
        } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            resultState = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.FALSE);
        }
        if (resultState != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, resultState, 11);
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)resultState));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult hoeAction(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.m_43725_();
        BlockState toolModifiedState = level.m_8055_(blockpos = context.m_8083_()).getToolModifiedState(context, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.m_150858_((BlockState)toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.m_43723_();
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(context);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (!this.isTierValid(state)) {
            return 1.0f;
        }
        MiningSpeedModuleItem module = IModuleStorage.getInstalledModules(stack).filter(MiningSpeedModuleItem.class::isInstance).map(MiningSpeedModuleItem.class::cast).findAny().orElse(null);
        if (module == null) {
            return 1.0f;
        }
        return module.getSpeed((this._tier.m_6624_() - 2.0f) / (float)Math.max(this.getRadius(stack) * 2, 1), state);
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        return true;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return IModuleStorage.getInstalledModuleStacks(stack).filter(obj -> obj.m_41720_() instanceof EnchantmentModuleItem).map(moduleStack -> moduleStack.getEnchantmentLevel(enchantment)).reduce(Integer::sum).orElse(0);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Stream<ItemStack> modules = IModuleStorage.getInstalledModuleStacks(stack);
        Stream<Map> maps = modules.filter(obj -> obj.m_41720_() instanceof EnchantmentModuleItem).map(IForgeItemStack::getAllEnchantments);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        maps.forEach(enchantmentIntegerMap -> enchantmentIntegerMap.forEach((enchantment, integer) -> map.merge((Enchantment)enchantment, (Integer)integer, Integer::sum)));
        return map;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? IModuleStorage.buildAttributesFromModules(slot, stack) : super.getAttributeModifiers(slot, stack);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.isTierValid(state);
    }

    private boolean isTierValid(BlockState state) {
        return this._tier == Tiers.NETHERITE || TierSortingRegistry.isCorrectTierForDrops((Tier)this._tier, (BlockState)state);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.isActive(oldStack) != this.isActive(newStack) || oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public static class GauntletEvents {
        private static final Set<BlockPos> _blocksHarvested = new ObjectOpenHashSet();

        private GauntletEvents() {
        }

        public static void init() {
            MinecraftForge.EVENT_BUS.addListener(GauntletEvents::onPlayerBreakSpeed);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, GauntletEvents::handleBlockBreakEvent);
            MinecraftForge.EVENT_BUS.addListener(GauntletEvents::handleTickEndEvent);
            IMCRegistries.Send.registerSolidifier((Block)Blocks.f_49994_, (Block)MachinesContent.HardenedGravel.block());
            IMCRegistries.Send.registerSolidifier((Block)Blocks.f_276445_, (Block)MachinesContent.HardenedGravel.block());
            IMCRegistries.Send.registerSolidifier((Block)Blocks.f_49992_, (Block)MachinesContent.HardenedSand.block());
            IMCRegistries.Send.registerSolidifier((Block)Blocks.f_271439_, (Block)MachinesContent.HardenedSand.block());
            IMCRegistries.Send.registerSolidifier((Block)Blocks.f_49993_, (Block)MachinesContent.HardenedRedSand.block());
        }

        public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = player2.m_21205_();
            Item item = stack.m_41720_();
            if (!(item instanceof GauntletItem)) {
                return;
            }
            GauntletItem gauntlet = (GauntletItem)item;
            int energyRequired = gauntlet.energyRequired((Player)player2, stack, false);
            int energyRequiredBase = gauntlet.energyRequired((Player)player2, stack, true);
            int radius = gauntlet.getRadius(stack);
            BlockPos origin = event.getPos();
            if (_blocksHarvested.contains(origin)) {
                return;
            }
            Level level = player2.m_9236_();
            Direction dir = GauntletEvents.getTargetLookDirection((Player)player2);
            ArrayList<BlockPos> blockPositions = gauntlet.getAffectedBlocks(stack, (LevelReader)level, origin, dir);
            ArrayList<Object> frozenBlocks = new ArrayList<BlockPos>();
            if (IModuleStorage.isInstalled(TunnelerModuleItem.class, stack)) {
                List<BlockPos> area = AreaUtils.getFromRadius(origin.m_121945_(dir.m_122424_()), dir, radius + 1, radius == 0 ? 0 : 1 - radius).toList();
                for (Direction adjDirection : Direction.values()) {
                    BlockPos adj = origin.m_121945_(adjDirection);
                    if (blockPositions.contains(adj) || area.contains(adj)) continue;
                    frozenBlocks.add(adj);
                }
                for (BlockPos blockPosition : blockPositions) {
                    for (Direction adjDirection : Direction.values()) {
                        BlockPos adj = blockPosition.m_121945_(adjDirection);
                        if (blockPositions.contains(adj) || area.contains(adj)) continue;
                        frozenBlocks.add(adj);
                    }
                }
                frozenBlocks = new ArrayList<BlockPos>(frozenBlocks.stream().distinct().filter(Predicate.not(blockPositions::contains)).toList());
            }
            if (blockPositions.size() == 0) {
                if (!EnergyUtils.playerHasEnergyToExtract((Player)player2, energyRequiredBase, true)) {
                    return;
                }
                EnergyUtils.playerHasEnergyToExtract((Player)player2, energyRequired, false);
                frozenBlocks.forEach((Consumer<Object>)((Consumer<BlockPos>)pos -> GauntletEvents.freeze(player2, pos)));
                return;
            }
            BlockState originState = level.m_8055_(origin);
            float originSpeed = originState.m_60800_((BlockGetter)level, origin);
            if (originSpeed < 0.01f) {
                blockPositions.removeIf(pos -> {
                    BlockState state = level.m_8055_(pos);
                    return state.m_60800_((BlockGetter)level, pos) > 0.01f;
                });
            }
            energyRequired *= (float)blockPositions.stream().filter(pos -> {
                BlockState state = player2.m_9236_().m_8055_(pos);
                return state.m_60800_((BlockGetter)level, pos) > 0.0f;
            }).count() + originState.m_60800_((BlockGetter)level, origin) > 0.0f ? 1 : 0;
            if (!EnergyUtils.playerHasEnergyToExtract((Player)player2, energyRequiredBase, true)) {
                return;
            }
            EnergyUtils.playerHasEnergyToExtract((Player)player2, energyRequired, false);
            frozenBlocks.forEach((Consumer<Object>)((Consumer<BlockPos>)pos -> GauntletEvents.freeze(player2, pos)));
            blockPositions.forEach(pos -> {
                if (level.m_8055_(pos).m_278721_()) {
                    BlockState air = Blocks.f_50016_.m_49966_();
                    level.m_46597_(pos, air);
                }
                _blocksHarvested.add((BlockPos)pos);
                player.f_8941_.m_9280_(pos);
                _blocksHarvested.remove(pos);
            });
        }

        public static ImmutableList<BlockPos> getRadiusBlocks(BlockPos origin, Player player, int radius) {
            return GauntletEvents.getRadiusBlocks(origin, player, GauntletEvents.getTargetLookDirection(player), radius);
        }

        public static ImmutableList<BlockPos> getRadiusBlocks(BlockPos origin, Player player, Direction dir, int radius) {
            float originBreakSpeed = player.m_9236_().m_8055_(origin).m_60800_((BlockGetter)player.m_9236_(), origin);
            int yMin = -1;
            int yMax = 2 * radius - 1;
            Stream areaStream = switch (dir) {
                case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, 0, -radius), (BlockPos)origin.m_7918_(radius, 0, radius));
                case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, yMin, 0), (BlockPos)origin.m_7918_(radius, yMax, 0));
                default -> BlockPos.m_121990_((BlockPos)origin.m_7918_(0, yMin, -radius), (BlockPos)origin.m_7918_(0, yMax, radius));
            };
            List area = areaStream.filter(blockPos -> GauntletEvents.isValidForBreaking(player, blockPos, originBreakSpeed)).map(BlockPos::m_7949_).collect(Collectors.toList());
            area.remove(origin);
            return ImmutableList.copyOf(area);
        }

        @NotNull
        public static Direction getTargetLookDirection(Player player) {
            Vec3 playerLook = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
            Vec3 lookVec = player.m_20252_(1.0f);
            double reach = player.getBlockReach();
            Vec3 endLook = playerLook.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
            ClipContext clip = new ClipContext(playerLook, endLook, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult hitResult = player.m_9236_().m_45547_(clip);
            return hitResult.m_82434_().m_122424_();
        }

        private static boolean isValidForBreaking(Player player, BlockPos blockPos, float commonBreakSpeed) {
            BlockState state = player.m_9236_().m_8055_(blockPos);
            ItemStack stack = player.m_21205_();
            if (state.m_60795_() || state.m_278721_()) {
                return false;
            }
            if (commonBreakSpeed == 0.0f) {
                float breakSpeed = state.m_60800_((BlockGetter)player.m_9236_(), blockPos);
                return breakSpeed == commonBreakSpeed;
            }
            return stack.m_41720_().m_8102_(stack, state) >= 0.0f;
        }

        public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                _blocksHarvested.clear();
            }
        }

        public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
            Player player = event.getEntity();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item item = stack.m_41720_();
            if (!(item instanceof GauntletItem)) {
                return;
            }
            GauntletItem gauntletItem = (GauntletItem)item;
            int energyRequired = gauntletItem.energyRequired(player, stack, true);
            float speed = event.getOriginalSpeed();
            if (IModuleStorage.isInstalled(AreaModuleItem.class, stack) && event.getPosition().isPresent()) {
                ImmutableList<BlockPos> blockPositions = GauntletEvents.getRadiusBlocks((BlockPos)event.getPosition().get(), player, GauntletEvents.getTargetLookDirection(player), gauntletItem.getRadius(stack));
                Level level = player.m_9236_();
                Float totalDTime = blockPositions.stream().map(pos -> Float.valueOf(level.m_8055_(pos).m_60800_((BlockGetter)level, pos))).reduce(Float::sum).orElse(Float.valueOf(0.0f));
                speed = Math.max(1.0f, speed - totalDTime.floatValue());
            }
            if (!player.m_20096_() && IModuleStorage.isInstalled(EnvironmentalModule.class, stack)) {
                speed *= 5.0f;
            }
            if (energyRequired > 0 && !EnergyUtils.playerHasEnergyToExtract(player, energyRequired, true)) {
                speed = 1.0f;
            }
            event.setNewSpeed(speed);
        }

        private static void freeze(ServerPlayer player, BlockPos pos) {
            Level level = player.m_9236_();
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) {
                return;
            }
            BlockState to = (BlockState)IMCRegistries.SolidBlockToFromMap.get(state);
            if (to == null) {
                if (state.m_278721_()) {
                    BlockState newState = Blocks.f_50652_.m_49966_();
                    level.m_7731_(pos, newState, 11);
                    XyMachines.NETWORK_HANDLER.broadcast((Packet.ClientBound)new CBFreezeBlockPacket(pos, state));
                    return;
                }
                return;
            }
            XyMachines.NETWORK_HANDLER.broadcast((Packet.ClientBound)new CBFreezeBlockPacket(pos, state));
            level.m_7731_(pos, to, 11);
        }

        public static void iterateBreadthSearch(BlockPos pos, Consumer<BlockPos> blockPosConsumer) {
            for (BlockPos adj : BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1)).map(BlockPos::m_7949_).toList()) {
                if (adj.equals((Object)pos)) continue;
                blockPosConsumer.accept(adj);
            }
        }

        public static boolean matchesVein(LevelReader level, BlockPos origin, ArrayList<BlockPos> blockPositions, BlockState originState, BlockPos pos) {
            if (pos.equals((Object)origin)) {
                return true;
            }
            if (level.m_8055_(pos).m_60713_(originState.m_60734_())) {
                blockPositions.add(pos);
                return true;
            }
            return false;
        }
    }
}

