/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.machines.config.EnergyType;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesCapabilities;
import tv.soaryn.xycraft.machines.content.capabilities.item.IXynergyStorageItem;
import tv.soaryn.xycraft.machines.content.capabilities.item.XynergyCapabilityProvider;

public class XynergyItem
extends XyItem
implements IXynergyStorageItem {
    protected ForgeConfigSpec.IntValue capacity;
    protected ForgeConfigSpec.IntValue extract;
    protected ForgeConfigSpec.IntValue receive;

    public XynergyItem(ForgeConfigSpec.IntValue capacity, ForgeConfigSpec.IntValue extract, ForgeConfigSpec.IntValue receive) {
        super(new Item.Properties().m_41487_(1).m_246768_(new FeatureFlag[]{FeatureFlags.f_244112_}));
        this.capacity = capacity;
        this.extract = extract;
        this.receive = receive;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        String energyType;
        super.m_7373_(stack, level, components, tooltipFlag);
        int capacity = this.getCapacity(stack);
        Capability<? extends IEnergyStorage> capability = this.getEnergyCapability();
        String suffix = "";
        switch ((EnergyType)((Object)MachinesConfig.EnergyParadigm.get())) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Xynergy: {
                String string = "Xynergy";
                break;
            }
            case ForgeEnergy: {
                String string = energyType = "FE";
            }
        }
        if (capability == ForgeCapabilities.ENERGY) {
            energyType = "FE";
        }
        components.add((Component)Component.m_237115_((String)"Battery Life: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)(this.getScaledEnergyStored(stack, 100.0f) + "%")).m_130940_(ChatFormatting.GRAY)));
        if (tooltipFlag.m_7050_()) {
            components.add((Component)Component.m_237115_((String)"(ADVANCED): ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)String.valueOf(this.getEnergyStored(stack))).m_130940_(ChatFormatting.GRAY)));
        }
        Style style = Style.f_131099_.m_178520_(0x55CCFF);
        components.add((Component)Component.m_237115_((String)"Capacity: ").m_130948_(style).m_7220_((Component)Component.m_237113_((String)String.format("%,d", capacity)).m_130946_(suffix + " ").m_130946_(energyType).m_130940_(ChatFormatting.GRAY)));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        this.setEnergyStored(stack, this.getCapacity(stack));
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new XynergyCapabilityProvider(stack, this, this.getEnergyCapability());
    }

    @Override
    public Capability<? extends IEnergyStorage> getEnergyCapability() {
        return switch ((EnergyType)((Object)MachinesConfig.EnergyParadigm.get())) {
            default -> throw new IncompatibleClassChangeError();
            case EnergyType.Xynergy -> MachinesCapabilities.Common.Xynergy;
            case EnergyType.ForgeEnergy -> ForgeCapabilities.ENERGY;
        };
    }

    @Override
    public int getMaxExtract(ItemStack container) {
        return (Integer)this.extract.get();
    }

    @Override
    public int getMaxReceive(ItemStack container) {
        return (Integer)this.receive.get();
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return (Integer)this.capacity.get();
    }
}

