/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.event.RegisterCommandsEvent;
import org.joml.Random;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesCommands;
import tv.soaryn.xycraft.machines.content.commands.ICommand;
import tv.soaryn.xycraft.world.content.WorldContent;

public record BuildCommand() implements ICommand
{
    private static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.f_50016_.m_49966_(), Collections.emptySet(), null);
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((bound, provided) -> Component.m_237110_((String)"commands.xycraft.buildtank.toobig", (Object[])new Object[]{bound, provided}));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.xycraft.buildtank.failed"));

    public static ICommand register(RegisterCommandsEvent event) {
        return new BuildCommand().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection(), event.getBuildContext());
    }

    @Override
    public ICommand register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandBuildContext context) {
        String KEY_FRAME = "frame";
        String KEY_FACE = "face";
        String KEY_ORIGIN = "origin";
        String KEY_SIZE = "size";
        Random rand = new Random();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"xycraft").requires(MachinesCommands::op)).then(Commands.m_82127_((String)"build").then(Commands.m_82127_((String)"tank").then(Commands.m_82129_((String)KEY_ORIGIN, (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)KEY_SIZE, (ArgumentType)IntegerArgumentType.integer((int)3, (int)((Integer)MachinesConfig.TankSizeLimit.get()))).executes(commandStack -> {
            BlockPos origin = BlockPosArgument.m_118242_((CommandContext)commandStack, (String)KEY_ORIGIN);
            int i = IntegerArgumentType.getInteger((CommandContext)commandStack, (String)KEY_SIZE) - 1;
            BlockPos to = origin.m_7918_(i, i, i);
            BlockInput defaultFace = new BlockInput(WorldContent.GlassViewerGlowing.block().m_49966_(), Collections.emptySet(), null);
            BlockInput defaultFrame = new BlockInput(((BlockContent[])WorldContent.AluminumBricksCloud.values().toArray(BlockContent[]::new))[rand.nextInt(WorldContent.AluminumBricksCloud.size())].block().m_49966_(), Collections.emptySet(), null);
            return BuildCommand.fillBlocks((CommandSourceStack)commandStack.getSource(), BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_((CommandContext)commandStack, (String)KEY_ORIGIN), (Vec3i)to), defaultFrame, defaultFace);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)KEY_FRAME, (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).executes(commandStack -> {
            BlockPos origin = BlockPosArgument.m_118242_((CommandContext)commandStack, (String)KEY_ORIGIN);
            int i = IntegerArgumentType.getInteger((CommandContext)commandStack, (String)KEY_SIZE) - 1;
            BlockPos to = origin.m_7918_(i, i, i);
            BlockInput defaultFace = new BlockInput(WorldContent.GlassViewerGlowing.block().m_49966_(), Collections.emptySet(), null);
            BlockInput input = BlockStateArgument.m_116123_((CommandContext)commandStack, (String)KEY_FRAME);
            return BuildCommand.fillBlocks((CommandSourceStack)commandStack.getSource(), BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_((CommandContext)commandStack, (String)KEY_ORIGIN), (Vec3i)to), input, defaultFace);
        })).then(Commands.m_82129_((String)KEY_FACE, (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).executes(commandStack -> {
            BlockPos origin = BlockPosArgument.m_118242_((CommandContext)commandStack, (String)KEY_ORIGIN);
            int i = IntegerArgumentType.getInteger((CommandContext)commandStack, (String)KEY_SIZE) - 1;
            BlockPos to = origin.m_7918_(i, i, i);
            return BuildCommand.fillBlocks((CommandSourceStack)commandStack.getSource(), BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_((CommandContext)commandStack, (String)KEY_ORIGIN), (Vec3i)to), BlockStateArgument.m_116123_((CommandContext)commandStack, (String)KEY_FRAME), BlockStateArgument.m_116123_((CommandContext)commandStack, (String)KEY_FACE));
        }))))))));
        return this;
    }

    private static int fillBlocks(CommandSourceStack commandStack, BoundingBox boundingBox, BlockInput frame, BlockInput face) throws CommandSyntaxException {
        int maxCount;
        int volume = boundingBox.m_71056_() * boundingBox.m_71057_() * boundingBox.m_71058_();
        if (volume > (maxCount = commandStack.m_81372_().m_46469_().m_46215_(GameRules.f_263760_))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)maxCount, (Object)volume);
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        ServerLevel serverlevel = commandStack.m_81372_();
        for (BlockPos blockpos : BlockPos.m_121976_((int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_(), (int)boundingBox.m_162399_(), (int)boundingBox.m_162400_(), (int)boundingBox.m_162401_())) {
            BlockEntity blockentity;
            BlockInput blockInputFrame = Mode.OUTLINE.filter.m_138619_(boundingBox, blockpos, frame, serverlevel);
            BlockInput blockInputFace = Mode.HOLLOW.filter.m_138619_(boundingBox, blockpos, face, serverlevel);
            if (blockInputFrame != null) {
                blockentity = serverlevel.m_7702_(blockpos);
                Clearable.m_18908_((Object)blockentity);
                if (!blockInputFrame.m_114670_(serverlevel, blockpos, 2)) continue;
                list.add(blockpos.m_7949_());
                continue;
            }
            if (blockInputFace == null) continue;
            blockentity = serverlevel.m_7702_(blockpos);
            Clearable.m_18908_((Object)blockentity);
            if (!blockInputFace.m_114670_(serverlevel, blockpos, 2)) continue;
            list.add(blockpos.m_7949_());
        }
        int count = list.size();
        if (count == 0) {
            throw ERROR_FAILED.create();
        }
        for (BlockPos updateList : list) {
            Block block = serverlevel.m_8055_(updateList).m_60734_();
            serverlevel.m_6289_(updateList, block);
        }
        commandStack.m_288197_(() -> Component.m_237110_((String)"commands.fill.success", (Object[])new Object[]{count}), true);
        return count;
    }

    static enum Mode {
        OUTLINE((boundingBox, pos, input, level) -> {
            if (pos.m_123341_() == boundingBox.m_162395_() && pos.m_123342_() == boundingBox.m_162396_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162395_() && pos.m_123342_() == boundingBox.m_162400_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162399_() && pos.m_123342_() == boundingBox.m_162396_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162399_() && pos.m_123342_() == boundingBox.m_162400_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162395_() && pos.m_123343_() == boundingBox.m_162398_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162399_() && pos.m_123343_() == boundingBox.m_162398_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162395_() && pos.m_123343_() == boundingBox.m_162401_()) {
                return input;
            }
            if (pos.m_123341_() == boundingBox.m_162399_() && pos.m_123343_() == boundingBox.m_162401_()) {
                return input;
            }
            if (pos.m_123343_() == boundingBox.m_162398_() && pos.m_123342_() == boundingBox.m_162396_()) {
                return input;
            }
            if (pos.m_123343_() == boundingBox.m_162398_() && pos.m_123342_() == boundingBox.m_162400_()) {
                return input;
            }
            if (pos.m_123343_() == boundingBox.m_162401_() && pos.m_123342_() == boundingBox.m_162396_()) {
                return input;
            }
            if (pos.m_123343_() == boundingBox.m_162401_() && pos.m_123342_() == boundingBox.m_162400_()) {
                return input;
            }
            return null;
        }),
        HOLLOW((boundingBox, pos, input, level) -> pos.m_123341_() != boundingBox.m_162395_() && pos.m_123341_() != boundingBox.m_162399_() && pos.m_123342_() != boundingBox.m_162396_() && pos.m_123342_() != boundingBox.m_162400_() && pos.m_123343_() != boundingBox.m_162398_() && pos.m_123343_() != boundingBox.m_162401_() ? HOLLOW_CORE : input);

        public final SetBlockCommand.Filter filter;

        private Mode(SetBlockCommand.Filter filter) {
            this.filter = filter;
        }
    }
}

