/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.capabilities.item;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.machines.content.capabilities.item.IXynergyStorage;
import tv.soaryn.xycraft.machines.content.capabilities.item.IXynergyStorageItem;

public class XynergyCapabilityProvider
implements IXynergyStorage,
ICapabilityProvider,
INBTSerializable<Tag> {
    private final Capability<? extends IEnergyStorage> capability;
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);
    protected final ItemStack container;
    protected final IXynergyStorageItem item;
    protected int energy;

    public XynergyCapabilityProvider(ItemStack containerIn, IXynergyStorageItem itemIn, Capability<? extends IEnergyStorage> capability) {
        this.container = containerIn;
        this.item = itemIn;
        this.capability = capability;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return !this.canReceive() ? 0 : this.item.receiveEnergy(this.container, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return !this.canExtract() ? 0 : this.item.extractEnergy(this.container, maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.item.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return this.item.getCapacity(this.container);
    }

    public boolean canExtract() {
        return this.item.getMaxExtract(this.container) > 0;
    }

    public boolean canReceive() {
        return this.item.getMaxReceive(this.container) > 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == this.capability ? this.holder.cast() : LazyOptional.empty();
    }

    public Tag serializeNBT() {
        return IntTag.m_128679_((int)this.getEnergyStored());
    }

    public void deserializeNBT(Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.energy = intNbt.m_7047_();
    }
}

