/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.capabilities.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

@AutoRegisterCapability
public interface IXynergyStorageItem {
    public static final String XynergyTag = "xynergy";

    public Capability<? extends IEnergyStorage> getEnergyCapability();

    public int getMaxExtract(ItemStack var1);

    public int getMaxReceive(ItemStack var1);

    default public int getEnergyStored(ItemStack stack) {
        return Math.min(this.getOrCreateEnergyTag(stack).m_128451_(XynergyTag), this.getCapacity(stack));
    }

    public int getCapacity(ItemStack var1);

    @NotNull
    default public CompoundTag getOrCreateEnergyTag(ItemStack stack) {
        return stack.m_41784_();
    }

    default public int getAvailableStorage(ItemStack stack) {
        return this.getCapacity(stack) - this.getEnergyStored(stack);
    }

    default public int getScaledEnergyStored(ItemStack container, float scale) {
        return Mth.m_14143_((float)((float)this.getEnergyStored(container) * scale / (float)this.getCapacity(container)));
    }

    default public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        CompoundTag tag = this.getOrCreateEnergyTag(stack);
        int stored = Math.min(tag.m_128451_(XynergyTag), this.getCapacity(stack));
        int receive = Math.min(Math.min(maxReceive, this.getMaxReceive(stack)), this.getAvailableStorage(stack));
        if (!simulate) {
            tag.m_128405_(XynergyTag, stored += receive);
        }
        return receive;
    }

    default public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        CompoundTag tag = this.getOrCreateEnergyTag(stack);
        int stored = Math.min(tag.m_128451_(XynergyTag), this.getCapacity(stack));
        int extract = Math.min(Math.min(maxExtract, this.getMaxExtract(stack)), stored);
        if (!simulate) {
            tag.m_128405_(XynergyTag, stored -= extract);
        }
        return extract;
    }

    default public void setEnergyStored(ItemStack stack, int energy) {
        this.getOrCreateEnergyTag(stack).m_128405_(XynergyTag, Mth.m_14045_((int)energy, (int)0, (int)this.getCapacity(stack)));
    }
}

