/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.multiblock;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.multiblock.TankMemberBlockEntity;
import tv.soaryn.xycraft.machines.content.multiblock.TankMultiBlock;

public class ValveBlockEntity
extends TankMemberBlockEntity
implements ITickable.Server {
    private final int seed;
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.empty();

    public ValveBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Valve.entity(), pos, state);
        this.seed = pos.hashCode();
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(ValveBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.FLUID_HANDLER ? this.fluidHandler.cast() : super.getCapability(cap, side);
    }

    @Override
    public boolean canPreserveFluid() {
        return true;
    }

    @Override
    protected void invalidateTankCaps() {
        this.fluidHandler.invalidate();
    }

    @Override
    protected void setupTankCaps(TankMultiBlock tank) {
        this.fluidHandler = LazyOptional.of(tank::getFluidHandler);
    }

    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (!ITickable.shouldTick((Level)level, (int)this.seed, (int)5)) {
            return;
        }
    }

    private void tryPumpFluid(@NotNull Level level, @NotNull BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
        if (blockEntity == null) {
            return;
        }
        if (this.fluidHandler.resolve().isEmpty()) {
            return;
        }
        IFluidHandler src = (IFluidHandler)this.fluidHandler.resolve().get();
        blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(iFluidHandler -> FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)src, (int)1000, (boolean)true));
    }
}

