/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.capabilities.volumes.LightFieldVolumeCache;
import tv.soaryn.xycraft.world.content.WorldContent;

public class LightFieldBlock
extends ColoredBlock {
    public LightFieldBlock() {
        super((ColorSource)CustomColors.Light, WorldContent.KiviProperties());
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LightFieldVolumeCache.of((Level)serverLevel).add((Level)serverLevel, pos);
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6810_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LightFieldVolumeCache.of((Level)serverLevel).remove((Level)serverLevel, pos);
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, LightFieldVolumeCache::register);
        MinecraftForge.EVENT_BUS.addListener(LightFieldBlock::onLoad);
        MinecraftForge.EVENT_BUS.addListener(LightFieldBlock::stopEnderWarp);
        MinecraftForge.EVENT_BUS.addListener(LightFieldBlock::preventSiege);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, LightFieldBlock::blockMobSpawn);
        MinecraftForge.EVENT_BUS.addListener(LightFieldBlock::blockSpecialSpawns);
    }

    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LightFieldVolumeCache.of((Level)serverLevel).load((Level)serverLevel);
        }
    }

    public static void stopEnderWarp(EntityTeleportEvent.EnderEntity event) {
        if (!((Boolean)MachinesConfig.LightFieldPreventEndermenWarpIn.get()).booleanValue()) {
            return;
        }
        BlockPos pos = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)event.getEntity().m_9236_(), LightFieldVolumeCache.LightFieldVolumeAnchor.class);
        volumes.find(pos).findFirst().ifPresent($ -> event.setCanceled(true));
    }

    public static void preventSiege(VillageSiegeEvent event) {
        if (!((Boolean)MachinesConfig.LightFieldPreventsSieges.get()).booleanValue()) {
            return;
        }
        Vec3 vec = event.getAttemptedSpawnPos();
        BlockPos pos = new BlockPos((int)vec.m_7096_(), (int)vec.m_7098_(), (int)vec.m_7094_());
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)event.getLevel(), LightFieldVolumeCache.LightFieldVolumeAnchor.class);
        volumes.find(pos).findFirst().ifPresent($ -> event.setCanceled(true));
    }

    public static void blockSpecialSpawns(MobSpawnEvent.FinalizeSpawn event) {
        FastVolumeLookup volumes;
        Mob entity = event.getEntity();
        if (event.isCanceled() || LightFieldBlock.isAllowed(event.getSpawnType())) {
            return;
        }
        if (entity.m_6095_() == EntityType.f_20509_) {
            FastVolumeLookup volumes2 = FastVolumeLookup.of((Level)event.getLevel().m_6018_(), LightFieldVolumeCache.LightFieldVolumeAnchor.class);
            if (volumes2.find(entity.m_20183_()).findFirst().isPresent()) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.setSpawnCancelled(true);
            } else if (volumes2.find(entity.m_20183_().m_6625_((Integer)MachinesConfig.LightFieldRange.get() * 3 / 2)).findFirst().isPresent()) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.setSpawnCancelled(true);
            }
        } else if ((entity.m_6095_() == EntityType.f_20513_ || entity.m_6095_() == EntityType.f_20494_ || entity.m_6095_() == EntityType.f_20488_) && (volumes = FastVolumeLookup.of((Level)event.getLevel().m_6018_(), LightFieldVolumeCache.LightFieldVolumeAnchor.class)).find(entity.m_20183_()).findFirst().isPresent()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            event.setSpawnCancelled(true);
        }
    }

    public static void blockMobSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
        if (event.getResult() != Event.Result.DEFAULT || LightFieldBlock.isAllowed(event.getSpawnType())) {
            return;
        }
        FastVolumeLookup volumes = FastVolumeLookup.of((Level)event.getLevel().m_6018_(), LightFieldVolumeCache.LightFieldVolumeAnchor.class);
        volumes.find(event.getPos()).findFirst().ifPresent(lightFieldVolumeAnchor -> event.setResult(Event.Result.DENY));
    }

    private static boolean isAllowed(MobSpawnType type) {
        return switch (type) {
            case MobSpawnType.BREEDING, MobSpawnType.COMMAND, MobSpawnType.MOB_SUMMONED, MobSpawnType.CONVERSION, MobSpawnType.BUCKET, MobSpawnType.SPAWN_EGG, MobSpawnType.DISPENSER -> true;
            case MobSpawnType.NATURAL, MobSpawnType.TRIGGERED, MobSpawnType.PATROL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.SPAWNER, MobSpawnType.STRUCTURE, MobSpawnType.JOCKEY, MobSpawnType.REINFORCEMENT, MobSpawnType.EVENT -> false;
            default -> {
                XyMachines.Logger.error("There is a missing type not handled:%s. Raise an issue on the tracker if there isn't already one `%s`".formatted(type.name(), "https://github.com/Soaryn/XyCraftTracker/issues"));
                yield false;
            }
        };
    }
}

