/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.IFluidSpreadPreventer;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.world.content.WorldContent;

public class FluidVoidBlock
extends ColoredBlock
implements IFluidSpreadPreventer {
    public FluidVoidBlock() {
        super((ColorSource)CustomColors.Dark, WorldContent.KiviProperties());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        ItemStack item = player.m_21120_(interactionHand);
        Optional optional = item.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (((Boolean)MachinesConfig.FluidVoidEmptiesContainer.get()).booleanValue() && optional.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)optional.get();
            FluidStack drained = handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            player.m_21008_(interactionHand, handler.getContainer());
            if (drained.getAmount() > 0) {
                SoundEvent soundEvent = drained.getFluid().getFluidType().getSound((Entity)player, SoundActions.BUCKET_EMPTY);
                if (soundEvent != null) {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState otherState, boolean flag) {
        super.m_6807_(state, level, pos, otherState, flag);
        this.removeFluid(level, pos);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState otherState, boolean flag) {
        super.m_6810_(state, level, pos, otherState, flag);
        for (Direction d : Direction.values()) {
            BlockPos targetPos = pos.m_121945_(d);
            BlockState targetState = level.m_8055_(targetPos);
            level.markAndNotifyBlock(targetPos, level.m_46745_(targetPos), targetState, targetState, 3, 512);
        }
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos otherPos, boolean flag) {
        this.removeFluid(level, pos);
        super.m_6861_(state, level, pos, block, otherPos, flag);
    }

    public void removeFluid(@NotNull Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BucketPickup pickup;
            BlockPos targetPos = pos.m_121945_(direction);
            BlockState targetState = level.m_8055_(targetPos);
            Block targetBlock = targetState.m_60734_();
            if (targetBlock instanceof BucketPickup && !(pickup = (BucketPickup)targetBlock).m_142598_((LevelAccessor)level, targetPos, targetState).m_41619_()) continue;
            if (targetBlock instanceof LiquidBlock) {
                level.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (targetState.m_60819_().m_76178_()) continue;
            BlockEntity blockentity = targetState.m_155947_() ? level.m_7702_(targetPos) : null;
            FluidVoidBlock.m_49892_((BlockState)targetState, (LevelAccessor)level, (BlockPos)targetPos, (BlockEntity)blockentity);
            level.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }
}

