/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.network.IByteBlockEntityPacketReceiver;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.network.packets.CBByteBlockEntityPacket;
import tv.soaryn.xycraft.core.utils.handlers.VoidEnergyHandler;
import tv.soaryn.xycraft.core.utils.handlers.VoidFluidHandler;
import tv.soaryn.xycraft.core.utils.handlers.VoidItemHandler;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesTags;

public class VoidContainerBlockEntity
extends CoreBlockEntity
implements ITickable.Server,
IByteBlockEntityPacketReceiver {
    public VoidContainerBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.VoidContainer.entity(), pos, state);
        this.Data = new VoidData();
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(VoidContainerBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    public VoidData getData() {
        if (this.Data == null) {
            this.Data = new VoidData();
        }
        return (VoidData)this.Data;
    }

    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        int voidAmountItem = (Integer)MachinesConfig.VoidContainmentItemAmount.get();
        int voidAmountFluid = (Integer)MachinesConfig.VoidContainmentFluidAmount.get();
        int voidAmountPower = (Integer)MachinesConfig.VoidContainmentPowerAmount.get();
        VoidData data = this.getData();
        if (ITickable.shouldTick((Level)level, (int)this.getData().getSeed(), (int)10) && (data.voidItemHandler.hasContentToVoid || data.voidFluidHandler.hasContentToVoid || data.voidEnergyHandler.hasContentToVoid)) {
            data.voidItemHandler.hasContentToVoid = false;
            data.voidFluidHandler.hasContentToVoid = false;
            data.voidEnergyHandler.hasContentToVoid = false;
            this.HandleParticle(level);
        }
        if (!ITickable.shouldTick((Level)level, (int)this.getData().getSeed(), (int)((Integer)MachinesConfig.VoidContainmentFrequency.get()))) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
        Direction opposite = direction.m_122424_();
        BlockPos posOfOther = pos.m_121945_(direction);
        BlockEntity otherBlockEntity = level.m_7702_(posOfOther);
        if (otherBlockEntity != null && !otherBlockEntity.m_58900_().m_204336_(MachinesTags.Blocks.VoidContainmentImmune)) {
            if (voidAmountFluid > 0) {
                otherBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, opposite).ifPresent(handler -> {
                    FluidStack drained = handler.drain(voidAmountFluid, IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() > 0) {
                        this.HandleParticle(level);
                    }
                });
            }
            if (voidAmountItem > 0) {
                otherBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, opposite).ifPresent(handler -> {
                    int currentAllowedAbsorbed = voidAmountItem;
                    for (int slot = 0; slot < handler.getSlots() && currentAllowedAbsorbed > 0; currentAllowedAbsorbed -= handler.extractItem(slot, currentAllowedAbsorbed, false).m_41613_(), ++slot) {
                    }
                    if (currentAllowedAbsorbed < voidAmountItem) {
                        this.HandleParticle(level);
                    }
                });
            }
            if (voidAmountPower > 0) {
                otherBlockEntity.getCapability(ForgeCapabilities.ENERGY, opposite).ifPresent(handler -> {
                    if (handler.canExtract() && handler.extractEnergy(voidAmountPower, false) > 0) {
                        this.HandleParticle(level);
                    }
                });
            }
        }
    }

    private void HandleParticle(@NotNull Level level) {
        XyCore.Network.broadcast(level, this.m_58899_(), (Packet.ClientBound)new CBByteBlockEntityPacket(this.m_58899_(), 1));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) == side) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return this.getData().fluidHandlerLazyOptional.cast();
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.getData().itemHandlerLazyOptional.cast();
            }
            if (cap == ForgeCapabilities.ENERGY) {
                return this.getData().energyHandlerLazyOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void receivePacket(CBByteBlockEntityPacket packet) {
        assert (this.f_58857_ != null);
        double d0 = (double)this.f_58858_.m_123341_() + 0.5;
        double d1 = (double)this.f_58858_.m_123342_() + 0.7;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public class VoidData
    implements IDataSync {
        public final VoidFluidHandler voidFluidHandler = new VoidFluidHandler();
        public final VoidItemHandler voidItemHandler = new VoidItemHandler();
        public final VoidEnergyHandler voidEnergyHandler = new VoidEnergyHandler();
        LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.voidFluidHandler);
        LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.voidItemHandler);
        LazyOptional<IEnergyStorage> energyHandlerLazyOptional = LazyOptional.of(() -> this.voidEnergyHandler);
        private int _seed;

        public void onLoad(CoreBlockEntity coreBlockEntity) {
            this._seed = VoidContainerBlockEntity.this.m_58899_().hashCode();
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            tag.m_128405_("seed", this._seed);
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            this._seed = tag.m_128451_("seed");
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            this.fluidHandlerLazyOptional.invalidate();
            this.itemHandlerLazyOptional.invalidate();
            this.energyHandlerLazyOptional.invalidate();
        }

        public int getSeed() {
            return this._seed;
        }
    }
}

