/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.ExtractorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;

public class ExtractorBlock
extends SidePartBlock
implements IColored,
EntityBlock,
ITickable {
    public ExtractorBlock() {
        super(MachinesContent.MachineProperties().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Error))).m_61124_(MachineStateProperties.IOMode, (Comparable)((Object)IOMode.Item)));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MachineStateProperties.Status});
        builder.m_61104_(new Property[]{MachineStateProperties.IOMode});
    }

    public VoxelShape getDownShapeForBaking() {
        VoxelShape column = ExtractorBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        return Shapes.m_83110_((VoxelShape)column, (VoxelShape)ExtractorBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ExtractorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        return ITickable.getTicker((Level)level, (BlockState)state, entityType);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
        BlockPos posOfInventory = pos.m_121945_(direction.m_122424_());
        BlockEntity inventoryBlockEntity = level.m_7702_(posOfInventory);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ExtractorBlockEntity) {
            ExtractorBlockEntity extractor = (ExtractorBlockEntity)blockEntity;
            ExtractorBlockEntity.ExtractorData.revalidateInventory(extractor, direction, inventoryBlockEntity);
        }
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this.getColor((MachineStatusColors)((Object)state.m_61143_(MachineStateProperties.Status)), index);
    }

    private int getColor(MachineStatusColors status, int index) {
        return index == 1 ? status.Color : -1;
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return this.getColor(MachineStatusColors.Success, index);
    }
}

