/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.event.ItemEntityTickEvent;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.core.utils.container.SimpleItemContainer;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.capabilities.volumes.CollectorVolumeCache;
import tv.soaryn.xycraft.machines.gui.CollectorMenu;
import tv.soaryn.xycraft.machines.network.CBCollectorAbsorbedPacket;

public class CollectorBlock
extends SidePartBlock
implements EntityBlock,
ITickable {
    public CollectorBlock() {
        super(MachinesContent.MachineProperties().m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return (BlockState)state.m_61124_(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        InteractionResult wrenchResult;
        ItemStack stack = player.m_21120_(interactionHand);
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)stack, (boolean)true) && (wrenchResult = IWrenchUse.rotate((BlockState)state, (Level)level, (BlockPos)pos, (BlockHitResult)hitResult)) != null) {
            return wrenchResult;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Entity) {
            Entity collector = (Entity)blockEntity;
            level.m_5594_(null, pos, SoundEvents.f_12409_, SoundSource.BLOCKS, 0.05f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (!level.m_5776_() && !(player instanceof FakePlayer)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)collector, (BlockPos)pos);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hitResult);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CollectorVolumeCache.of((Level)serverLevel).add((Level)serverLevel, pos);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(oldState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)entity.getData().Buffer.asVanillaContainer());
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)entity.getData().Inventory.asVanillaContainer());
        }
        super.m_6810_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CollectorVolumeCache.of((Level)serverLevel).remove((Level)serverLevel, pos);
        }
    }

    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            CollectorVolumeCache.of((Level)serverLevel).load((Level)serverLevel);
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, CollectorVolumeCache::register);
        MinecraftForge.EVENT_BUS.addListener(CollectorBlock::onLoad);
        MinecraftForge.EVENT_BUS.addListener(Entity::onItemEntityForm);
        MinecraftForge.EVENT_BUS.addListener(Entity::onItemTick);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MachineStateProperties.Status});
    }

    public VoxelShape getDownShapeForBaking() {
        VoxelShape node = CollectorBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        VoxelShape port = CollectorBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
        VoxelShape base = CollectorBlock.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
        return Shapes.m_83124_((VoxelShape)node, (VoxelShape[])new VoxelShape[]{port, base});
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean p_60514_) {
        Direction direction;
        Entity collector;
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, p_60514_);
        MachineStatusColors currentStatus = (MachineStatusColors)((Object)state.m_61143_(MachineStateProperties.Status));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Entity) {
            collector = (Entity)blockEntity;
            direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
            BlockPos posOfInventory = pos.m_121945_(direction.m_122424_());
            BlockEntity inventoryBlockEntity = level.m_7702_(posOfInventory);
            Entity.CollectorData data = collector.getData();
            if (inventoryBlockEntity != null) {
                data._externalItemOptional = inventoryBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_());
            } else {
                data._externalItemOptional.invalidate();
            }
        }
        if (level.m_276867_(pos)) {
            if (currentStatus == MachineStatusColors.Off) {
                return;
            }
            BlockState newState = (BlockState)state.m_61124_(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Off));
            level.m_46597_(pos, newState);
            level.markAndNotifyBlock(pos, level.m_46745_(pos), newState, newState, 3, 512);
        } else if (currentStatus == MachineStatusColors.Off && (direction = level.m_7702_(pos)) instanceof Entity) {
            collector = (Entity)direction;
            Entity.CollectorData data = collector.getData();
            BlockState newState = (BlockState)state.m_61124_(MachineStateProperties.Status, (Comparable)((Object)(data._externalItemOptional.resolve().isPresent() ? MachineStatusColors.Success : MachineStatusColors.Idle)));
            level.m_46597_(pos, newState);
            level.markAndNotifyBlock(pos, level.m_46745_(pos), newState, newState, 3, 512);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        return ITickable.getTicker((Level)level, (BlockState)state, entityType);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new Entity(pos, state);
    }

    public static class Entity
    extends CoreBlockEntity
    implements ITickable.Server,
    MenuProvider {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Collector.entity(), pos, state);
            this.Data = new CollectorData();
        }

        public static BlockEntityType<?> supplier(Block block) {
            return new BlockEntityType(Entity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
        }

        public CollectorData getData() {
            return (CollectorData)this.Data;
        }

        public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            ItemStack result;
            ItemStack input;
            int i;
            Optional resolved;
            CollectorData data = this.getData();
            if (!ITickable.shouldTick((Level)level, (int)data._seed, (int)10)) {
                return;
            }
            Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
            Direction opposite = direction.m_122424_();
            BlockEntity otherBlockEntity = level.m_7702_(pos.m_121945_(direction));
            if (otherBlockEntity != null) {
                if (!data._externalItemOptional.isPresent()) {
                    data._externalItemOptional = otherBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, opposite);
                }
            } else {
                data._externalItemOptional.invalidate();
            }
            if ((resolved = data._externalItemOptional.resolve()).isPresent()) {
                IItemHandler handler = (IItemHandler)resolved.get();
                boolean changed = false;
                for (i = 0; i < data.Inventory.size(); ++i) {
                    input = data.Inventory.get(i);
                    if (input.m_41619_()) continue;
                    result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)input, (boolean)false);
                    data.Inventory.set(i, result);
                    changed = true;
                }
                if (changed) {
                    this.m_6596_();
                }
            }
            boolean changed = false;
            boolean hasSomeRoom = false;
            for (i = 0; i < data.Buffer.size(); ++i) {
                input = data.Buffer.get(i);
                if (input.m_41619_()) {
                    hasSomeRoom = true;
                    continue;
                }
                result = ItemHandlerHelper.insertItemStacked((IItemHandler)data._internalInventoryItemHandler, (ItemStack)input, (boolean)false);
                data.Buffer.set(i, result);
                changed = true;
                if (!result.m_41619_()) continue;
                hasSomeRoom = true;
            }
            if (hasSomeRoom) {
                if (state.m_61143_(MachineStateProperties.Status) == MachineStatusColors.Idle) {
                    BlockState newState = (BlockState)state.m_61124_(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success));
                    level.m_46597_(pos, newState);
                    level.markAndNotifyBlock(pos, level.m_46745_(pos), newState, newState, 3, 512);
                }
            } else if (state.m_61143_(MachineStateProperties.Status) == MachineStatusColors.Success) {
                BlockState newState = (BlockState)state.m_61124_(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Idle));
                level.m_46597_(pos, newState);
                level.markAndNotifyBlock(pos, level.m_46745_(pos), newState, newState, 3, 512);
            }
            if (changed) {
                this.m_6596_();
            }
        }

        @Nullable
        public Packet<ClientGamePacketListener> m_58483_() {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            super.onDataPacket(net, pkt);
            Level level = this.m_58904_();
            if (level == null) {
                return;
            }
            level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER && this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) == side) {
                return this.getData().InventoryLazyHandle.cast();
            }
            return super.getCapability(cap, side);
        }

        public static void onItemTick(ItemEntityTickEvent event) {
            Level level = event.getEntity().m_9236_();
            ItemEntity itemEntity = event.getEntity();
            if (level.m_5776_() || !ITickable.shouldTick((Level)level, (int)itemEntity.m_19879_(), (int)10)) {
                return;
            }
            Entity.absorbItem(level, itemEntity, (EntityEvent)event);
        }

        public static void onItemEntityForm(EntityJoinLevelEvent event) {
            net.minecraft.world.entity.Entity entity;
            Level level = event.getLevel();
            if (event.isCanceled() || level == null || level.m_5776_() || !((entity = event.getEntity()) instanceof ItemEntity)) {
                return;
            }
            ItemEntity itemEntity = (ItemEntity)entity;
            if (Entity.absorbItem(level, itemEntity, (EntityEvent)event)) {
                itemEntity.m_32060_();
                if (itemEntity.m_32055_().m_41619_()) {
                    event.setCanceled(true);
                }
            }
        }

        private static boolean absorbItem(Level level, ItemEntity itemEntity, EntityEvent event) {
            BlockPos pos = itemEntity.m_20183_();
            List<CollectorVolumeCache.CollectorVolumeAnchor> volumes = FastVolumeLookup.of((Level)level, CollectorVolumeCache.CollectorVolumeAnchor.class).find(pos).filter(anchor -> {
                BlockState state = level.m_8055_(anchor.getAnchorPos());
                return state.m_60713_(anchor.getAnchorBlock()) && state.m_61143_(MachineStateProperties.Status) == MachineStatusColors.Success;
            }).sorted(Comparator.comparingDouble(anchor -> anchor.getAnchorPos().m_123331_((Vec3i)pos))).toList();
            if (volumes.isEmpty()) {
                return false;
            }
            ItemStack entityItemstack = itemEntity.m_32055_();
            ItemStack remainder = entityItemstack.m_41777_();
            ArrayList<BlockPos> acceptedVolumes = new ArrayList<BlockPos>();
            for (CollectorVolumeCache.CollectorVolumeAnchor volume : volumes) {
                if (remainder.m_41619_()) break;
                BlockEntity blockEntity = level.m_7702_(volume.getAnchorPos());
                if (!(blockEntity instanceof Entity)) continue;
                Entity collector = (Entity)blockEntity;
                CollectorData data = collector.getData();
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)data._bufferItemHandler, (ItemStack)remainder.m_41777_(), (boolean)false);
                collector.m_6596_();
                acceptedVolumes.add(volume.getAnchorPos());
            }
            if (!ItemStack.m_41728_((ItemStack)entityItemstack, (ItemStack)remainder)) {
                itemEntity.m_32045_(remainder);
                for (BlockPos acceptedVolume : acceptedVolumes) {
                    XyMachines.NETWORK_HANDLER.broadcast(level, pos, (Packet.ClientBound)new CBCollectorAbsorbedPacket(itemEntity.m_20182_().m_252839_(), acceptedVolume));
                }
                return true;
            }
            return false;
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"gui.xycraft_machines.collector");
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            return new CollectorMenu(windowId, playerInventory, (BlockEntity)this, (ItemContainer)this.getData().Inventory, (ItemContainer)this.getData().Buffer);
        }

        public class CollectorData
        implements IDataSync {
            public ItemContainer.Serializable Buffer = new SimpleItemContainer(8, () -> ((Entity)Entity.this).m_6596_());
            public ItemContainer.Serializable Inventory = new SimpleItemContainer(8, () -> ((Entity)Entity.this).m_6596_());
            private LazyOptional<IItemHandler> _externalItemOptional = LazyOptional.empty();
            private final IItemHandler _internalInventoryItemHandler = this.Inventory.asItemHandler();
            private final IItemHandler _inventoryItemHandler = this.Inventory.asItemHandler(new ItemContainer.ItemHandlerBehavior(){

                public boolean canInsert(int slot, @NotNull ItemStack stack) {
                    return false;
                }
            });
            private final IItemHandler _bufferItemHandler = this.Buffer.asItemHandler();
            private final LazyOptional<IItemHandler> InventoryLazyHandle = LazyOptional.of(() -> this._inventoryItemHandler);
            private int _seed;

            public void onLoad(CoreBlockEntity coreBlockEntity) {
                this._seed = coreBlockEntity.m_58899_().hashCode();
            }

            public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                tag.m_128365_("buffer", (Tag)this.Buffer.serializeNBT());
                tag.m_128365_("inventory", (Tag)this.Inventory.serializeNBT());
            }

            public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                if (tag.m_128441_("buffer")) {
                    this.Buffer.deserializeNBT(tag.m_128469_("buffer"));
                }
                if (tag.m_128441_("inventory")) {
                    this.Inventory.deserializeNBT(tag.m_128469_("inventory"));
                }
            }

            public void invalidate(CoreBlockEntity coreBlockEntity) {
                this.InventoryLazyHandle.invalidate();
            }
        }
    }
}

