/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tv.soaryn.xycraft.core.utils.rules.IRule;

public class CodecUtils {
    public static final Supplier<Codec<FluidType>> FluidTypeCodec = Suppliers.memoize(() -> ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getCodec());

    public static JsonElement encodeRuleTest(IRule test) {
        DataResult result = IRule.Codec.encode((Object)test, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
        result.error().ifPresent(err -> {
            throw new RuntimeException("Could not create json from codec: " + test);
        });
        return (JsonElement)result.result().orElseThrow();
    }

    public static IRule decodeRuleTest(JsonElement json) {
        DataResult decoded = IRule.Codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        decoded.error().ifPresent(err -> {
            throw new RuntimeException("Failed to parse json rule test.");
        });
        return (IRule)((Pair)decoded.result().orElseThrow()).getFirst();
    }
}

