/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widget;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.widget.WidgetState;

public interface IWidget {
    @NotNull
    public Data getData();

    public void render(@NotNull GuiGraphics var1, int var2, int var3, float var4);

    default public boolean onMouseDown(double x, double y, int button) {
        return false;
    }

    default public boolean onMouseUp(double x, double y, int button) {
        return false;
    }

    default public boolean onMouseScrolled(double x, double y, double amount) {
        return false;
    }

    default public void onToolTip(double mouseX, double mouseY, List<Component> tooltip) {
        Component tip = this.getData().ToolTip;
        if (tip != null) {
            tooltip.add(tip);
        }
    }

    default public IWidget setToolTip(Component component) {
        this.getData().ToolTip = component;
        return this;
    }

    default public void setHovering(boolean flag) {
        this.getData().IsMouseOver = flag;
    }

    default public void onTick(BaseMenuUI<?> ui) {
    }

    public static class Data {
        public BaseMenuUI<?> Ui;
        public boolean IsMouseOver = false;
        public float Rotation = 0.0f;
        public Rectangle Dimensions = Rectangle.identity();
        public WidgetState State = WidgetState.Idle;
        public Component ToolTip;

        public Data() {
        }

        public Data(BaseMenuUI<?> ui) {
            this();
            this.Ui = ui;
        }

        public Data(BaseMenuUI<?> ui, float x, float y, float width, float height) {
            this(ui);
            new Rectangle(x, y, width, height);
        }
    }

    public static interface Foreground
    extends IWidget {
    }

    public static interface Background
    extends IWidget {
    }
}

