/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.container.FancySlot;
import tv.soaryn.xycraft.core.utils.container.GhostSlot;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;

public abstract class BaseMenu
extends AbstractContainerMenu {
    private final List<Region> regions = new ArrayList<Region>();
    private final Int2ObjectMap<Region> slotRegions = new Int2ObjectOpenHashMap();
    protected final Inventory playerInv;
    private final ResourceLocation texture;
    private final int width;
    private final int height;

    protected BaseMenu(Supplier<? extends MenuType<?>> type, int id, Inventory playerInv, ResourceLocation texture, int width, int height) {
        super(type.get(), id);
        this.playerInv = playerInv;
        this.texture = texture;
        this.width = width;
        this.height = height;
    }

    protected final Region createRegion() {
        Region region = new Region();
        this.regions.add(region);
        return region;
    }

    public void onMessage(int component, byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        this.onMessage(component, buf);
        buf.release();
    }

    public abstract void onMessage(int var1, FriendlyByteBuf var2);

    public ResourceLocation texture() {
        return this.texture;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        Region region = (Region)this.slotRegions.get(slotIndex);
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (region == null || !slot.m_6657_() || !slot.m_8010_(player)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_().m_41777_();
        for (RegionHandle handle : region.shiftTargets) {
            for (Slot target : handle.getSlots()) {
                if (!this.m_38903_(stack, target.f_40219_, target.f_40219_ + 1, false) || !stack.m_41619_()) continue;
                slot.m_5852_(stack);
                return ItemStack.f_41583_;
            }
        }
        slot.m_5852_(stack);
        return ItemStack.f_41583_;
    }

    public final class Region
    implements RegionHandle {
        private final List<Slot> slots = new ArrayList<Slot>();
        private final List<RegionHandle> shiftTargets = new ArrayList<RegionHandle>();

        private Region() {
        }

        public Slot addSlot(int x, int y, Container container, int slot) {
            return this.addSlots(x, y, 1, 1, container, slot).iterator().next();
        }

        public Iterable<Slot> addSlots(int x, int y, int rows, int columns, Container container, int start) {
            return this.addSlots(x, y, rows, columns, (x1, y1, id) -> new Slot(container, id + start, x1, y1));
        }

        public FancySlot addSlot(int x, int y, ItemContainer inventory, int slot) {
            return this.addSlots(x, y, 1, 1, inventory, slot).iterator().next();
        }

        public Iterable<FancySlot> addSlots(int x, int y, int rows, int columns, ItemContainer inventory, int start) {
            return this.addSlots(x, y, rows, columns, (x1, y1, id) -> new FancySlot(x1, y1, inventory, id + start));
        }

        public GhostSlot addGhostSlot(int x, int y, ItemContainer inventory, int slot, int limit) {
            return this.addGhostSlots(x, y, 1, 1, inventory, slot, limit).iterator().next();
        }

        public Iterable<GhostSlot> addGhostSlots(int x, int y, int rows, int columns, ItemContainer inventory, int start, int limit) {
            return this.addSlots(x, y, rows, columns, (x1, y1, id) -> new GhostSlot(x1, y1, inventory, id + start, limit));
        }

        public <T extends Slot> Iterable<T> addSlots(int x, int y, int rows, int columns, SlotFactory<T> slotFactory) {
            int firstIndex = this.slots.size();
            for (int j = 0; j < rows; ++j) {
                for (int i = 0; i < columns; ++i) {
                    this.addSlot(slotFactory.createSlot(x + i * 18, y + j * 18, i + j * columns));
                }
            }
            return this.slots.subList(firstIndex, this.slots.size());
        }

        public <T extends Slot> T addSlot(T slot) {
            this.slots.add(slot);
            BaseMenu.this.slotRegions.put(BaseMenu.this.f_38839_.size(), (Object)this);
            BaseMenu.this.m_38897_(slot);
            return slot;
        }

        public void addPlayerSlots(Inventory playerInv) {
            this.addPlayerSlots(playerInv, false);
        }

        public void addPlayerSlots(Inventory playerInv, boolean lockSelected) {
            this.addPlayerSlots((BaseMenu.this.width - 160) / 2, BaseMenu.this.height - 82, playerInv, lockSelected);
        }

        public void addPlayerSlots(int x, int y, Inventory playerInv) {
            this.addPlayerSlots(x, y, playerInv, false);
        }

        public void addPlayerSlots(int x, int y, Inventory playerInv, boolean lockSelected) {
            if (lockSelected) {
                this.addSlots(x, y, 3, 9, (Container)playerInv, 9);
                this.addSlots(x, y + 58, 1, 9, (x1, y1, id) -> new Slot((Container)playerInv, id, x1, y1){

                    public boolean m_8010_(@NotNull Player player) {
                        return this.getSlotIndex() != ((Inventory)this.f_40218_).f_35977_;
                    }

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return this.getSlotIndex() != ((Inventory)this.f_40218_).f_35977_;
                    }
                });
            } else {
                this.addSlots(x, y, 3, 9, (Container)playerInv, 9);
                this.addSlots(x, y + 58, 1, 9, (Container)playerInv, 0);
            }
        }

        public void onChanged(Consumer<FancySlot> callback) {
            for (Slot slot : this.slots) {
                if (!(slot instanceof FancySlot)) continue;
                FancySlot s = (FancySlot)slot;
                s.onChanged(callback);
            }
        }

        public void addShiftTargets(RegionHandle ... regions) {
            this.shiftTargets.addAll(Arrays.asList(regions));
        }

        @Override
        public List<Slot> getSlots() {
            return this.slots;
        }

        public Reversed reversed() {
            return new Reversed();
        }

        public final class Reversed
        implements RegionHandle {
            private Reversed() {
            }

            @Override
            public List<Slot> getSlots() {
                ArrayList<Slot> list = new ArrayList<Slot>(Region.this.slots);
                Collections.reverse(list);
                return list;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RegionHandle {
        public List<Slot> getSlots();
    }

    @FunctionalInterface
    public static interface SlotFactory<T extends Slot> {
        public T createSlot(int var1, int var2, int var3);
    }
}

