/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.gildingarmor;

import com.google.gson.JsonObject;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipes;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class GildingArmorRecipe
extends SmithingTransformRecipe {
    private static final int ARMOR_SLOT_ID = 1;
    private static final int ADDITION_SLOT_ID = 2;

    public GildingArmorRecipe(ResourceLocation id) {
        super(id, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, ItemStack.f_41583_);
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        ItemStack input = inv.m_8020_(1);
        ItemStack addition = inv.m_8020_(2);
        Item item = input.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            if (!GildingArmorRecipe.isGilded(input) && GildingArmorRecipe.canGild(armor, input)) {
                return addition.m_41720_() == ModItems.gildingCrystal;
            }
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv, @Nonnull RegistryAccess registry) {
        ItemStack stack = inv.m_8020_(1).m_41777_();
        stack.m_41784_().m_128379_("Gilded_UtilitiX", true);
        return stack;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registry) {
        return ItemStack.f_41583_;
    }

    public boolean m_266253_(@Nonnull ItemStack addition) {
        return addition.m_41720_() == ModItems.gildingCrystal;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.GILDING_SERIALIZER;
    }

    public static boolean isGilded(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128471_("Gilded_UtilitiX");
    }

    public static boolean canGild(ArmorItem armor, ItemStack stack) {
        if (armor.m_40401_() == ArmorMaterials.GOLD) {
            return false;
        }
        try {
            Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
            return !armor.makesPiglinsNeutral(stack, (LivingEntity)player);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static class Serializer
    implements RecipeSerializer<GildingArmorRecipe> {
        @Nonnull
        public GildingArmorRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            return new GildingArmorRecipe(id);
        }

        public GildingArmorRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            return new GildingArmorRecipe(id);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull GildingArmorRecipe recipe) {
        }
    }
}

