/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.util;

import cofh.core.common.config.IBaseConfig;
import java.util.function.Supplier;
import mrthomas20121.thermal_extra.recipe.AdvancedRefineryRecipeManager;
import mrthomas20121.thermal_extra.recipe.ColdFuelManager;
import mrthomas20121.thermal_extra.recipe.ComponentAssemblyRecipeManager;
import mrthomas20121.thermal_extra.recipe.EndothermicDehydratorRecipeManager;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipeManager;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterRecipeManager;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalExtraConfig
implements IBaseConfig {
    private Supplier<Integer> dynamoColdPower;
    private Supplier<Integer> machineAdvancedRefineryPower;
    private Supplier<Integer> machineComponentAssemblyPower;
    private Supplier<Integer> machineEndothermicDehydratorPower;
    private Supplier<Integer> machineFluidMixerPower;
    private Supplier<Integer> machineNitraticIgniterPower;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Dynamos");
        builder.push("Stirling");
        this.dynamoColdPower = builder.comment("This sets the base power generation (RF/t) for the Cold Dynamo.").defineInRange("Base Power", ColdFuelManager.instance().getBasePower(), ColdFuelManager.instance().getMinPower(), ColdFuelManager.instance().getMaxPower());
        builder.pop();
        builder.pop();
        builder.push("Machines");
        builder.push("Advanced Refinery");
        this.machineAdvancedRefineryPower = builder.comment("This sets the base power consumption (RF/t) for the Advanced Refinery.").defineInRange("Base Power", AdvancedRefineryRecipeManager.instance().getBasePower(), AdvancedRefineryRecipeManager.instance().getMinPower(), AdvancedRefineryRecipeManager.instance().getMaxPower());
        builder.pop();
        builder.push("Component Assembly");
        this.machineComponentAssemblyPower = builder.comment("This sets the base power consumption (RF/t) for the Component Assembly.").defineInRange("Base Power", ComponentAssemblyRecipeManager.instance().getBasePower(), ComponentAssemblyRecipeManager.instance().getMinPower(), ComponentAssemblyRecipeManager.instance().getMaxPower());
        builder.pop();
        builder.push("Endothermic Dehydrator");
        this.machineEndothermicDehydratorPower = builder.comment("This sets the base power consumption (RF/t) for the Endothermic Dehydrator.").defineInRange("Base Power", EndothermicDehydratorRecipeManager.instance().getBasePower(), EndothermicDehydratorRecipeManager.instance().getMinPower(), EndothermicDehydratorRecipeManager.instance().getMaxPower());
        builder.pop();
        builder.push("Fluid Mixer");
        this.machineFluidMixerPower = builder.comment("This sets the base power consumption (RF/t) for the Fluid Mixer.").defineInRange("Base Power", FluidMixerRecipeManager.instance().getBasePower(), FluidMixerRecipeManager.instance().getMinPower(), FluidMixerRecipeManager.instance().getMaxPower());
        builder.pop();
        builder.push("Nitratic Igniter");
        this.machineNitraticIgniterPower = builder.comment("This sets the base power consumption (RF/t) for the Nitratic Igniter.").defineInRange("Base Power", NitraticIgniterRecipeManager.instance().getBasePower(), NitraticIgniterRecipeManager.instance().getMinPower(), NitraticIgniterRecipeManager.instance().getMaxPower());
        builder.pop();
    }

    public void refresh() {
        if (this.dynamoColdPower != null) {
            ColdFuelManager.instance().setBasePower(this.dynamoColdPower.get());
        }
        if (this.machineAdvancedRefineryPower != null) {
            AdvancedRefineryRecipeManager.instance().setBasePower(this.machineAdvancedRefineryPower.get());
        }
        if (this.machineComponentAssemblyPower != null) {
            ComponentAssemblyRecipeManager.instance().setBasePower(this.machineComponentAssemblyPower.get());
        }
        if (this.machineEndothermicDehydratorPower != null) {
            EndothermicDehydratorRecipeManager.instance().setBasePower(this.machineEndothermicDehydratorPower.get());
        }
        if (this.machineFluidMixerPower != null) {
            FluidMixerRecipeManager.instance().setBasePower(this.machineFluidMixerPower.get());
        }
        if (this.machineNitraticIgniterPower != null) {
            NitraticIgniterRecipeManager.instance().setBasePower(this.machineNitraticIgniterPower.get());
        }
    }
}

