/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.inventory;

import cofh.core.common.inventory.ContainerMenuCoFH;
import cofh.core.common.network.packet.server.ContainerConfigPacket;
import cofh.core.util.filter.BaseItemFilter;
import cofh.core.util.filter.FilterHolderType;
import cofh.core.util.filter.IFilterOptions;
import cofh.core.util.filter.IFilterable;
import cofh.core.util.filter.IFilterableItem;
import cofh.core.util.helpers.FilterHelper;
import cofh.lib.common.inventory.SlotFalseCopy;
import cofh.lib.common.inventory.SlotLocked;
import cofh.lib.common.inventory.wrapper.InvWrapperGeneric;
import cofh.lib.util.helpers.MathHelper;
import mrthomas20121.thermal_extra.init.ThermalExtraContainers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedItemFilterMenu
extends ContainerMenuCoFH
implements IFilterOptions {
    protected BlockEntity tile;
    protected Entity entity;
    protected IFilterable filterable;
    protected ItemStack filterStack;
    protected IFilterableItem filterableItem;
    public SlotLocked lockedSlot;
    protected BaseItemFilter filter = BaseItemFilter.ZERO;
    protected InvWrapperGeneric filterInventory;
    public final FilterHolderType type;

    public AdvancedItemFilterMenu(int windowId, Level world, Inventory inventory, Player player, int holder, int id, BlockPos pos) {
        super((MenuType)ThermalExtraContainers.ADVANCED_ITEM_FILTER_CONTAINER.get(), windowId, inventory, player);
        this.type = FilterHolderType.from((int)holder);
        switch (this.type) {
            case SELF: 
            case ITEM: {
                this.filterStack = FilterHelper.hasFilter((ItemStack)player.m_21205_()) ? player.m_21205_() : player.m_21206_();
                this.filterableItem = (IFilterableItem)this.filterStack.m_41720_();
                this.filter = (BaseItemFilter)this.filterableItem.getFilter(this.filterStack);
                break;
            }
            case TILE: {
                this.tile = world.m_7702_(pos);
                if (!FilterHelper.hasFilter((BlockEntity)this.tile)) break;
                this.filterable = (IFilterable)this.tile;
                this.filter = (BaseItemFilter)this.filterable.getFilter();
                break;
            }
            case ENTITY: {
                this.entity = world.m_6815_(id);
                if (!FilterHelper.hasFilter((Entity)this.entity)) break;
                this.filterable = (IFilterable)this.entity;
                this.filter = (BaseItemFilter)this.filterable.getFilter();
            }
        }
        this.allowSwap = false;
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperGeneric((AbstractContainerMenu)this, this.filter.getItems(), slots){

            public void m_6596_() {
                AdvancedItemFilterMenu.this.filter.setItems(AdvancedItemFilterMenu.this.filterInventory.getStacks());
            }
        };
        int rows = MathHelper.clamp((int)(slots / 3), (int)1, (int)3);
        int rowSize = slots / rows;
        int xOffset = 80 - 9 * rowSize;
        int yOffset = 45 - 9 * rows;
        for (int i = 0; i < slots; ++i) {
            this.m_38897_((Slot)new SlotFalseCopy((Container)this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    protected void bindPlayerInventory(Inventory inventory) {
        if (this.type == FilterHolderType.SELF || this.type == FilterHolderType.ITEM) {
            int i;
            int xOffset = this.getPlayerInventoryHorizontalOffset();
            int yOffset = this.getPlayerInventoryVerticalOffset();
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                if (i == inventory.f_35977_) {
                    this.lockedSlot = new SlotLocked((Container)inventory, i, xOffset + i * 18, yOffset + 58);
                    this.m_38897_((Slot)this.lockedSlot);
                    continue;
                }
                this.m_38897_(new Slot((Container)inventory, i, xOffset + i * 18, yOffset + 58));
            }
        } else {
            super.bindPlayerInventory(inventory);
        }
    }

    public IFilterable getFilterable() {
        return this.filterable;
    }

    public IFilterableItem getFilterableItem() {
        return this.filterableItem;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    protected int getMergeableSlotCount() {
        return this.filterInventory.m_6643_();
    }

    public boolean m_6875_(Player player) {
        if (this.type == FilterHolderType.SELF || this.type == FilterHolderType.ITEM) {
            return this.lockedSlot.m_7993_() == this.filterStack;
        }
        if (this.entity != null) {
            if (!FilterHelper.hasFilter((Entity)this.entity)) {
                return false;
            }
            return !this.entity.m_213877_() && this.entity.m_20182_().m_82557_(player.m_20182_()) <= 64.0;
        }
        if (!FilterHelper.hasFilter((BlockEntity)this.tile)) {
            return false;
        }
        return this.tile != null && !this.tile.m_58901_() && this.tile.m_58899_().m_203193_((Position)player.m_20182_()) <= 64.0;
    }

    public void m_6877_(Player playerIn) {
        this.filter.setItems(this.filterInventory.getStacks());
        if (this.type == FilterHolderType.SELF || this.type == FilterHolderType.ITEM) {
            this.filter.write(this.filterStack.m_41784_());
            this.filterableItem.onFilterChanged(this.filterStack);
        } else {
            this.filterable.onFilterChanged();
        }
        super.m_6877_(playerIn);
    }

    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    public void handleConfigPacket(FriendlyByteBuf buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerConfigPacket.sendToServer((ContainerMenuCoFH)this);
        return ret;
    }

    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerConfigPacket.sendToServer((ContainerMenuCoFH)this);
        return ret;
    }
}

