/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.Label;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class LimitedOutputSlot<STACK, ITEM, CAP> {
    public ResourceType<STACK, ITEM, CAP> type;
    public CAP handler;
    public BlockPos pos;
    public Label label;
    public int slot;
    public boolean freed;
    public OutputResourceTracker<STACK, ITEM, CAP> tracker;
    private Direction direction;
    @Nullable
    private STACK stackInSlotCache = null;

    public LimitedOutputSlot(Label label, BlockPos pos, Direction direction, int slot, CAP handler, OutputResourceTracker<STACK, ITEM, CAP> tracker, STACK stack) {
        this.init(handler, label, pos, direction, slot, tracker, stack);
    }

    public boolean isDone() {
        if (this.tracker.isDone()) {
            return true;
        }
        if (this.slot > this.type.getSlots(this.handler) - 1) {
            return true;
        }
        STACK stack = this.getStackInSlot();
        long count = this.type.getAmount(stack);
        if (count >= this.type.getMaxStackSizeForSlot(this.handler, this.slot)) {
            return true;
        }
        return count != 0L && !this.tracker.test(stack);
    }

    public STACK getStackInSlot() {
        if (this.stackInSlotCache == null) {
            this.stackInSlotCache = this.type.getStackInSlot(this.handler, this.slot);
        }
        return this.stackInSlotCache;
    }

    public STACK insert(STACK stack, boolean simulate) {
        if (!simulate) {
            this.stackInSlotCache = null;
        }
        return this.type.insert(this.handler, this.slot, stack, simulate);
    }

    public void init(CAP handler, Label label, BlockPos pos, Direction direction, int slot, OutputResourceTracker<STACK, ITEM, CAP> tracker, STACK stack) {
        this.stackInSlotCache = stack;
        this.handler = handler;
        this.tracker = tracker;
        this.slot = slot;
        this.pos = pos;
        this.label = label;
        this.direction = direction;
        this.freed = false;
        this.type = tracker.getLimit().resourceId().getResourceType();
        if (this.type == null) {
            throw new NullPointerException("type");
        }
    }

    public String toString() {
        return "LimitedOutputSlot{label=" + this.label + ", pos=" + this.pos + ", direction=" + this.direction + ", slot=" + this.slot + ", cap=" + this.type.displayAsCapabilityClass() + ", tracker=" + this.tracker + "}";
    }
}

