/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.Label;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class LimitedInputSlot<STACK, ITEM, CAP> {
    public ResourceType<STACK, ITEM, CAP> type;
    public CAP handler;
    public BlockPos pos;
    public Label label;
    public Direction direction;
    public int slot;
    public boolean freed;
    public InputResourceTracker<STACK, ITEM, CAP> tracker;
    @Nullable
    private STACK extractSimulateCache = null;
    private boolean done = false;

    public LimitedInputSlot(Label label, BlockPos pos, Direction direction, int slot, CAP handler, InputResourceTracker<STACK, ITEM, CAP> tracker, STACK stack) {
        this.init(handler, label, pos, direction, slot, tracker, stack);
    }

    public boolean isDone() {
        if (this.done) {
            return true;
        }
        if (this.tracker.isDone()) {
            return true;
        }
        if (this.slot > this.type.getSlots(this.handler) - 1) {
            return true;
        }
        STACK stack = this.peekExtractPotential();
        if (this.type.isEmpty(stack)) {
            return true;
        }
        return !this.tracker.test(stack);
    }

    public void setDone() {
        this.done = true;
    }

    public STACK extract(long amount) {
        this.extractSimulateCache = null;
        return this.type.extract(this.handler, this.slot, amount, false);
    }

    public STACK peekExtractPotential() {
        if (this.extractSimulateCache == null) {
            this.extractSimulateCache = this.type.extract(this.handler, this.slot, Long.MAX_VALUE, true);
        }
        return this.extractSimulateCache;
    }

    public void init(CAP handler, Label label, BlockPos pos, Direction direction, int slot, InputResourceTracker<STACK, ITEM, CAP> tracker, STACK stack) {
        this.done = false;
        this.extractSimulateCache = stack;
        this.handler = handler;
        this.tracker = tracker;
        this.slot = slot;
        this.pos = pos;
        this.label = label;
        this.direction = direction;
        this.freed = false;
        this.type = tracker.getResourceLimit().resourceId().getResourceType();
        if (this.type == null) {
            throw new NullPointerException("type");
        }
    }

    public String toString() {
        return "LimitedInputSlot{label=" + this.label + ", pos=" + this.pos + ", direction=" + this.direction + ", slot=" + this.slot + ", cap=" + this.type.displayAsCapabilityClass() + ", tracker=" + this.tracker + "}";
    }
}

