/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.item.NetworkToolItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ItemWorldRenderer {
    private static final int BUFFER_SIZE = 256;
    private static final RenderType RENDER_TYPE = RenderType.m_173215_((String)"sfmlabels", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, false)).m_110663_(new RenderStateShard.DepthTestStateShard("always", 519)).m_110685_(new RenderStateShard.TransparencyStateShard("src_to_one", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).m_110691_(true));
    @Nullable
    private static VertexBuffer capabilityProviderVBO;
    @Nullable
    private static VertexBuffer cableVBO;

    @SubscribeEvent
    public static void renderLabelHighlights(RenderLevelStageEvent event) {
        ItemStack networkTool;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack labelGun = player.m_21205_();
        if (!(labelGun.m_41720_() instanceof LabelGunItem)) {
            labelGun = player.m_21206_();
        }
        if (labelGun.m_41720_() instanceof LabelGunItem) {
            LabelPositionHolder labels = LabelPositionHolder.from(labelGun);
            HashMultimap labelPositions = HashMultimap.create();
            labels.forEach((label, pos1) -> labelPositions.put(pos1, label));
            PoseStack poseStack = event.getPoseStack();
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderSystem.disableDepthTest();
            poseStack.m_85836_();
            poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
            for (Map.Entry entry : labelPositions.asMap().entrySet()) {
                ItemWorldRenderer.drawLabel(poseStack, camera, (BlockPos)entry.getKey(), (MultiBufferSource)bufferSource, (Collection)entry.getValue());
            }
            RENDER_TYPE.m_110185_();
            if (capabilityProviderVBO == null) {
                capabilityProviderVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                capabilityProviderVBO.m_85921_();
                capabilityProviderVBO.m_231221_(ItemWorldRenderer.createCapabilityProviderVBO());
            } else {
                capabilityProviderVBO.m_85921_();
            }
            for (BlockPos pos : labelPositions.keySet()) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                capabilityProviderVBO.m_253207_(poseStack.m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
                poseStack.m_85849_();
            }
            VertexBuffer.m_85931_();
            RENDER_TYPE.m_110188_();
            bufferSource.m_109911_();
            poseStack.m_85849_();
            RenderSystem.enableDepthTest();
        }
        if (!((networkTool = player.m_21205_()).m_41720_() instanceof NetworkToolItem)) {
            networkTool = player.m_21206_();
        }
        if (networkTool.m_41720_() instanceof NetworkToolItem) {
            ArrayList cablePositions = new ArrayList();
            ArrayList capabilityProviderPositions = new ArrayList();
            networkTool.m_41784_().m_128437_("networks", 10).forEach(networkTag -> {
                ((CompoundTag)networkTag).m_128437_("cable_positions", 10).stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).forEach(cablePositions::add);
                ((CompoundTag)networkTag).m_128437_("capability_provider_positions", 10).stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).forEach(capabilityProviderPositions::add);
            });
            PoseStack poseStack = event.getPoseStack();
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderSystem.disableDepthTest();
            poseStack.m_85836_();
            poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
            RENDER_TYPE.m_110185_();
            if (capabilityProviderVBO == null) {
                capabilityProviderVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                capabilityProviderVBO.m_85921_();
                capabilityProviderVBO.m_231221_(ItemWorldRenderer.createCapabilityProviderVBO());
            } else {
                capabilityProviderVBO.m_85921_();
            }
            for (BlockPos blockPos : capabilityProviderPositions) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
                capabilityProviderVBO.m_253207_(poseStack.m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
                poseStack.m_85849_();
            }
            if (cableVBO == null) {
                cableVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                cableVBO.m_85921_();
                cableVBO.m_231221_(ItemWorldRenderer.createCableVBO());
            } else {
                cableVBO.m_85921_();
            }
            for (BlockPos blockPos : cablePositions) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
                cableVBO.m_253207_(poseStack.m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
                poseStack.m_85849_();
            }
            VertexBuffer.m_85931_();
            RENDER_TYPE.m_110188_();
            bufferSource.m_109911_();
            poseStack.m_85849_();
            RenderSystem.enableDepthTest();
        }
    }

    private static void drawLabel(PoseStack poseStack, Camera camera, BlockPos pos, MultiBufferSource mbs, Collection<String> labels) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.m_91087_().f_91062_;
        double d = labels.size();
        Objects.requireNonNull(font);
        poseStack.m_85837_(0.0, d * (9.0 + 0.1) / -2.0, 0.0);
        for (String label : labels) {
            font.m_271703_(label, (float)(-font.m_92895_(label)) / 2.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), mbs, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            Objects.requireNonNull(font);
            poseStack.m_85837_(0.0, 9.0 + 0.1, 0.0);
        }
        poseStack.m_85849_();
    }

    public static BufferBuilder.RenderedBuffer createCapabilityProviderVBO() {
        return ItemWorldRenderer.createShape(100, 0, 255, 100);
    }

    public static BufferBuilder.RenderedBuffer createCableVBO() {
        return ItemWorldRenderer.createShape(100, 255, 0, 100);
    }

    public static BufferBuilder.RenderedBuffer createShape(int r, int g, int b, int a) {
        BufferBuilder builder = new BufferBuilder(192);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_5483_(0.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 1.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 1.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 1.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 1.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 0.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 0.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 1.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 0.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 0.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 1.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(1.0, 0.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 0.0, 1.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_(0.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        return builder.m_231175_();
    }
}

