/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.common.net.ServerboundBoolExprStatementInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundIfStatementInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundInputInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundOutputInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfml.SFMLLexer;
import ca.teamdman.sfml.SFMLParser;
import ca.teamdman.sfml.ast.ASTBuilder;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class ProgramTokenContextActions {
    public static Optional<Runnable> getContextAction(String programString, int cursorPosition) {
        SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)programString));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SFMLParser parser = new SFMLParser((TokenStream)tokens);
        ASTBuilder builder = new ASTBuilder();
        try {
            builder.visitProgram(parser.program());
            SFM.LOGGER.info("Gathering context actions for cursor position {}", (Object)cursorPosition);
            return Stream.concat(builder.getNodesUnderCursor(cursorPosition).stream(), builder.getNodesUnderCursor(cursorPosition - 1).stream()).map(pair -> ProgramTokenContextActions.getContextAction(programString, builder, (ASTNode)pair.getFirst(), (ParserRuleContext)pair.getSecond(), cursorPosition)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        catch (Throwable t) {
            return Optional.of(() -> ClientStuff.showProgramEditScreen("-- Encountered error, program parse failed:\n--" + t.getMessage()));
        }
    }

    public static Optional<Runnable> getContextAction(String programString, ASTBuilder builder, ASTNode node, ParserRuleContext parserRuleContext, int cursorPosition) {
        SFM.LOGGER.info("Checking if context action exists for node {} {}", node.getClass(), (Object)node);
        if (node instanceof ResourceIdentifier) {
            ResourceIdentifier rid = (ResourceIdentifier)node;
            SFM.LOGGER.info("Found context action for resource identifier node");
            return Optional.of(() -> {
                String expansion = rid.expand().stream().map(ResourceIdentifier::toStringCondensed).collect(Collectors.joining(",\n"));
                ClientStuff.showProgramEditScreen(expansion);
            });
        }
        if (node instanceof Label) {
            Label label = (Label)node;
            SFM.LOGGER.info("Found context action for label node");
            return Optional.of(() -> SFMPackets.INSPECTION_CHANNEL.sendToServer((Object)new ServerboundLabelInspectionRequestPacket(label.name())));
        }
        if (node instanceof InputStatement) {
            if (cursorPosition > parserRuleContext.getStart().getStartIndex() + "INPUT".length()) {
                SFM.LOGGER.info("Found context action for input node, but the cursor isn't at the start of the node");
                return Optional.empty();
            }
            SFM.LOGGER.info("Found context action for input node");
            int nodeIndex = builder.getIndexForNode(node);
            return Optional.of(() -> SFMPackets.INSPECTION_CHANNEL.sendToServer((Object)new ServerboundInputInspectionRequestPacket(programString, nodeIndex)));
        }
        if (node instanceof OutputStatement) {
            if (cursorPosition > parserRuleContext.getStart().getStartIndex() + "OUTPUT".length()) {
                SFM.LOGGER.info("Found context action for output node, but the cursor isn't at the start of the node");
                return Optional.empty();
            }
            SFM.LOGGER.info("Found context action for output node");
            int nodeIndex = builder.getIndexForNode(node);
            return Optional.of(() -> SFMPackets.INSPECTION_CHANNEL.sendToServer((Object)new ServerboundOutputInspectionRequestPacket(programString, nodeIndex)));
        }
        if (node instanceof BoolExpr) {
            SFM.LOGGER.info("Found context action for BoolExpr node");
            int nodeIndex = builder.getIndexForNode(node);
            return Optional.of(() -> SFMPackets.INSPECTION_CHANNEL.sendToServer((Object)new ServerboundBoolExprStatementInspectionRequestPacket(programString, nodeIndex)));
        }
        if (node instanceof IfStatement) {
            SFM.LOGGER.info("Found context action for if statement node");
            int nodeIndex = builder.getIndexForNode(node);
            return Optional.of(() -> SFMPackets.INSPECTION_CHANNEL.sendToServer((Object)new ServerboundIfStatementInspectionRequestPacket(programString, nodeIndex)));
        }
        return Optional.empty();
    }

    public static boolean hasContextAction(Token token) {
        return switch (token.getType()) {
            case 1, 4, 27, 28, 68 -> true;
            default -> false;
        };
    }
}

