/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client;

import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfml.SFMLLexer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;

public class ProgramSyntaxHighlightingHelper {
    public static List<MutableComponent> withSyntaxHighlighting(String programString, boolean showContextActionHints) {
        Token token;
        SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)programString));
        lexer.INCLUDE_UNUSED = true;
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer){

            public List<Token> getHiddenTokensToRight(int tokenIndex, int channel) {
                if (channel == 0) {
                    return this.getHiddenTokensToRight(tokenIndex, 1);
                }
                return super.getHiddenTokensToRight(tokenIndex, channel);
            }

            public List<Token> getHiddenTokensToLeft(int tokenIndex, int channel) {
                if (channel == 0) {
                    return this.getHiddenTokensToLeft(tokenIndex, 1);
                }
                return super.getHiddenTokensToLeft(tokenIndex, channel);
            }
        };
        ArrayList<MutableComponent> textComponents = new ArrayList<MutableComponent>();
        MutableComponent lineComponent = Component.m_237119_();
        tokens.fill();
        Iterator iterator = tokens.getTokens().iterator();
        while (iterator.hasNext() && (token = (Token)iterator.next()).getType() != -1) {
            String[] lines = token.getText().split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                String line;
                if (i != 0) {
                    textComponents.add(lineComponent);
                    lineComponent = Component.m_237119_();
                }
                if ((line = lines[i]).isEmpty()) continue;
                MutableComponent text = Component.m_237113_((String)line).m_130948_(ProgramSyntaxHighlightingHelper.getStyle(token, showContextActionHints));
                lineComponent = lineComponent.m_7220_((Component)text);
            }
        }
        textComponents.add(lineComponent);
        return textComponents;
    }

    private static Style getStyle(Token token, boolean showContextActionHints) {
        Style style = Style.f_131099_;
        style = style.m_131140_(ProgramSyntaxHighlightingHelper.getColour(token));
        if (showContextActionHints && ProgramTokenContextActions.hasContextAction(token)) {
            style = style.m_131162_(Boolean.valueOf(true));
        }
        return style;
    }

    private static ChatFormatting getColour(Token token) {
        switch (token.getType()) {
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return ChatFormatting.DARK_PURPLE;
            }
            case 71: {
                return ChatFormatting.GRAY;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return ChatFormatting.LIGHT_PURPLE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 34: 
            case 56: 
            case 59: 
            case 60: 
            case 61: {
                return ChatFormatting.BLUE;
            }
            case 68: 
            case 70: {
                return ChatFormatting.GREEN;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 30: 
            case 31: 
            case 33: 
            case 51: 
            case 52: 
            case 53: {
                return ChatFormatting.GOLD;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 37: 
            case 69: {
                return ChatFormatting.AQUA;
            }
            case 54: 
            case 55: 
            case 73: {
                return ChatFormatting.RED;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return ChatFormatting.YELLOW;
            }
        }
        return ChatFormatting.WHITE;
    }
}

