/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.setup;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.blocks.SolarPanelBlock;
import edivad.solargeneration.items.SolarHelmet;
import edivad.solargeneration.lootable.SolarPanelLootFunction;
import edivad.solargeneration.menu.SolarPanelMenu;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    public static final Map<SolarPanelLevel, RegistryObject<SolarPanelBlock>> SOLAR_PANEL_BLOCK = new HashMap<SolarPanelLevel, RegistryObject<SolarPanelBlock>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> SOLAR_PANEL_ITEM = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<SolarPanelLevel, RegistryObject<BlockEntityType<SolarPanelBlockEntity>>> SOLAR_PANEL_TILE = new HashMap<SolarPanelLevel, RegistryObject<BlockEntityType<SolarPanelBlockEntity>>>();
    public static final Map<SolarPanelLevel, RegistryObject<MenuType<SolarPanelMenu>>> SOLAR_PANEL_CONTAINER = new HashMap<SolarPanelLevel, RegistryObject<MenuType<SolarPanelMenu>>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> HELMET = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> CORE = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<String, RegistryObject<LootItemFunctionType>> REGISTERED_LOOT_ITEM_FUNCTIONS = new HashMap<String, RegistryObject<LootItemFunctionType>>();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"solargeneration");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"solargeneration");
    public static final RegistryObject<Item> LAPIS_SHARD = ITEMS.register("lapis_shard", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> PHOTOVOLTAIC_CELL = ITEMS.register("photovoltaic_cell", () -> new Item(new Item.Properties()));
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"solargeneration");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"solargeneration");
    private static final DeferredRegister<LootItemFunctionType> LOOT_ITEM_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"solargeneration");

    public static void init(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        LOOT_ITEM_FUNCTIONS.register(modEventBus);
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SOLAR_PANEL_BLOCK.put(level, (RegistryObject<SolarPanelBlock>)BLOCKS.register(level.getSolarPanelName(), () -> new SolarPanelBlock(level, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60999_().m_60913_(1.5f, 6.0f))));
            SOLAR_PANEL_ITEM.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarPanelName(), () -> new BlockItem((Block)SOLAR_PANEL_BLOCK.get((Object)level).get(), new Item.Properties())));
            SOLAR_PANEL_TILE.put(level, (RegistryObject<BlockEntityType<SolarPanelBlockEntity>>)TILES.register(level.getSolarPanelName(), () -> BlockEntityType.Builder.m_155273_((pos, state) -> new SolarPanelBlockEntity(level, pos, state), (Block[])new Block[]{(Block)SOLAR_PANEL_BLOCK.get((Object)level).get()}).m_58966_(null)));
            SOLAR_PANEL_CONTAINER.put(level, (RegistryObject<MenuType<SolarPanelMenu>>)CONTAINERS.register(level.getSolarPanelName(), () -> IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                BlockEntity blockEntity = inv.f_35978_.m_20193_().m_7702_(pos);
                if (!(blockEntity instanceof SolarPanelBlockEntity)) {
                    SolarGeneration.LOGGER.error("Wrong type of block entity (expected BlockEntitySolarPanel)!");
                    return null;
                }
                SolarPanelBlockEntity solarPanelBlockEntity = (SolarPanelBlockEntity)blockEntity;
                return new SolarPanelMenu(windowId, solarPanelBlockEntity, level);
            })));
            HELMET.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarHelmetName(), () -> new SolarHelmet(level, new Item.Properties().m_41487_(1))));
            CORE.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarCoreName(), () -> new Item(new Item.Properties())));
        }
        REGISTERED_LOOT_ITEM_FUNCTIONS.put("solar_panel", (RegistryObject<LootItemFunctionType>)LOOT_ITEM_FUNCTIONS.register("solar_panel", () -> new LootItemFunctionType((Serializer)new SolarPanelLootFunction.Serializer())));
    }
}

