/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.items;

import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class SolarHelmet
extends ArmorItem {
    private final SolarPanelLevel solarPanelLevel;
    private final SolarPanelBattery energyStorage;
    private final int energyGeneration;
    private final int maxTransfer;

    public SolarHelmet(SolarPanelLevel solarPanelLevel, Item.Properties properties) {
        super(solarPanelLevel.getArmorMaterial(), ArmorItem.Type.HELMET, properties);
        this.solarPanelLevel = solarPanelLevel;
        this.energyGeneration = solarPanelLevel.getEnergyGeneration();
        this.maxTransfer = solarPanelLevel.getMaxTransfer();
        int capacity = solarPanelLevel.getCapacity();
        this.energyStorage = new SolarPanelBattery(this.maxTransfer, capacity);
    }

    public boolean m_41465_() {
        return false;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            int energy = this.getEnergyStored(stack);
            tooltip.add((Component)Tooltip.showInfoCtrl(energy));
        }
        tooltip.addAll(Tooltip.showInfoShift(this.solarPanelLevel));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.solarPanelLevel.getArmorTexture();
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.solarPanelLevel;
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        if (this.getEnergyStored(itemStack) == 0) {
            return 0;
        }
        double charge = (double)this.getEnergyStored(itemStack) / (double)this.getMaxEnergyStored();
        return (int)Math.min(1.0 + 12.0 * charge, 13.0);
    }

    public void saveEnergyItem(ItemStack itemStack) {
        itemStack.m_41784_().m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return 0;
        }
        return itemStack.m_41783_().m_128451_("energy");
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void onArmorTick(ItemStack itemStack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (this.getEnergyStored(itemStack) != this.getMaxEnergyStored()) {
            this.energyStorage.generatePower(this.currentAmountEnergyProduced(level, player));
        }
        this.sendEnergy(player);
        this.saveEnergyItem(itemStack);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        if (stack.m_41783_() == null) {
            this.energyStorage.setEnergy(0);
            this.saveEnergyItem(stack);
        } else {
            this.energyStorage.setEnergy(this.getEnergyStored(stack));
        }
        return super.getEquipmentSlot(stack);
    }

    private void sendEnergy(Player player) {
        ItemStack item;
        int i;
        for (i = 36; i < 40 && this.energyStorage.getEnergyStored() > 0; ++i) {
            item = player.m_150109_().m_8020_(i);
            this.chargeItem(item);
        }
        for (i = 0; i < 36 && this.energyStorage.getEnergyStored() > 0; ++i) {
            item = player.m_150109_().m_8020_(i);
            this.chargeItem(item);
        }
    }

    private void chargeItem(ItemStack slot) {
        if (slot.m_41613_() == 1) {
            slot.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                if (handler.canReceive()) {
                    while (handler.getEnergyStored() < handler.getMaxEnergyStored() && this.energyStorage.getEnergyStored() > 0) {
                        int accepted = Math.min(this.maxTransfer, handler.receiveEnergy(this.energyStorage.getEnergyStored(), true));
                        this.energyStorage.consumePower(accepted);
                        handler.receiveEnergy(accepted, false);
                    }
                }
            });
        }
    }

    private int currentAmountEnergyProduced(Level level, Player player) {
        if (!this.energyStorage.isFullEnergy()) {
            return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(level, player.m_20183_().m_7918_(0, 1, 0), this.getLevelSolarPanel()));
        }
        return 0;
    }
}

