/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world;

import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public final class IslandPos {
    private final int x;
    private final int z;
    private BlockPos center;
    private final TemplateInfo.Offset offset;

    public IslandPos(Level level, int x, int z, ConfiguredTemplate template) {
        this(x, Mth.m_14045_((int)(WorldUtil.calcSpawnHeight(level, x, z) + template.getOffset().y()), (int)level.m_141937_(), (int)level.m_151558_()), z, template.getOffset());
    }

    public IslandPos(int x, int y, int z, ConfiguredTemplate template) {
        this(x, y, z, template.getOffset());
    }

    public IslandPos(int x, int y, int z, TemplateInfo.Offset offset) {
        this.x = x;
        this.z = z;
        this.offset = offset;
        this.center = new BlockPos(this.x * WorldConfig.islandDistance + offset.x(), y, this.z * WorldConfig.islandDistance + offset.z());
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public void changeHeight(int y) {
        this.center = this.center.m_175288_(y);
    }

    public static IslandPos fromTag(CompoundTag tag) {
        return new IslandPos(tag.m_128451_("IslandX"), tag.m_128451_("Height"), tag.m_128451_("IslandZ"), new TemplateInfo.Offset(tag.m_128441_("OffsetX") ? tag.m_128451_("OffsetX") : TemplatesConfig.defaultOffset, tag.m_128441_("OffsetY") ? tag.m_128451_("OffsetY") : 0, tag.m_128441_("OffsetZ") ? tag.m_128451_("OffsetZ") : TemplatesConfig.defaultOffset));
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("IslandX", this.x);
        tag.m_128405_("IslandZ", this.z);
        tag.m_128405_("Height", this.center.m_123342_());
        tag.m_128405_("OffsetX", this.offset.x());
        tag.m_128405_("OffsetZ", this.offset.z());
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IslandPos)) {
            return false;
        }
        IslandPos islandPos = (IslandPos)o;
        return this.x == islandPos.x && this.z == islandPos.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.z;
        return result;
    }
}

