/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.template.NetherPortalTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.world.presets.SkyblockPreset;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.moddingx.libx.codec.MoreCodecs;

public class CoreUtil {
    public static Codec<WorldPreset> augmentWorldPresetCodec(Codec<WorldPreset> codec) {
        Codec skyblockCodecBase = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_255175_((ResourceKey)Registries.f_256787_), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_273919_), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_256932_), (App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(SkyblockPreset::getBiomes)).apply((Applicative)instance, SkyblockPreset::new));
        MapCodec skyblockCodecId = Codec.STRING.fieldOf("type").flatXmap(str -> "skyblockbuilder:skyblock".equals(str) ? DataResult.success((Object)Unit.INSTANCE) : DataResult.error(() -> "Wrong type"), unit -> DataResult.success((Object)"skyblockbuilder:skyblock"));
        Codec skyblockCodec = MoreCodecs.extend((Codec)skyblockCodecBase, (MapCodec)skyblockCodecId, preset -> Pair.of((Object)preset, (Object)Unit.INSTANCE), (preset, unit) -> preset);
        return new SkyblockPresetCodec(codec, (Codec<SkyblockPreset>)skyblockCodec);
    }

    public static Optional<BlockUtil.FoundRectangle> getExitPortal(ServerPlayer player, ServerLevel destination, BlockPos findFrom, boolean isToNether, WorldBorder worldBorder) {
        Direction.Axis portalAxis = player.m_9236_().m_8055_(player.f_19819_).m_61145_((Property)NetherPortalBlock.f_54904_).orElse(Direction.Axis.X);
        if (!isToNether || TemplateLoader.getNetherPortalTemplate() == null) {
            Optional portal = destination.m_8871_().m_77666_(findFrom, portalAxis);
            if (portal.isEmpty()) {
                SkyblockBuilder.getLogger().error("Unable to create a portal, likely target out of worldborder");
            }
            return portal;
        }
        Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)portalAxis);
        Rotation rotation = dir == Direction.SOUTH ? Rotation.CLOCKWISE_90 : Rotation.NONE;
        NetherPortalTemplate netherPortalTemplate = TemplateLoader.getNetherPortalTemplate();
        BlockPos.MutableBlockPos startPos = findFrom.m_121955_((Vec3i)netherPortalTemplate.getPortalOffset().m_7954_(rotation)).m_122032_();
        BlockPos.MutableBlockPos topPos = startPos.m_7949_().m_6630_(netherPortalTemplate.getStructure().f_74484_.m_123342_()).m_122032_();
        int logicalBuildHeight = destination.m_141937_() + destination.m_143344_();
        if (logicalBuildHeight < topPos.m_123342_()) {
            topPos.m_142448_(logicalBuildHeight);
            int i = 1;
            while (destination.m_8055_((BlockPos)topPos).m_60713_(Blocks.f_50752_)) {
                topPos.m_122173_(Direction.DOWN);
                ++i;
            }
            startPos.m_142448_(logicalBuildHeight - netherPortalTemplate.getStructure().f_74484_.m_123342_() - i);
        }
        if (destination.m_141937_() > startPos.m_123342_()) {
            startPos.m_142448_(destination.m_141937_());
            while (destination.m_8055_((BlockPos)startPos).m_60713_(Blocks.f_50752_)) {
                startPos.m_122173_(Direction.UP);
            }
        }
        netherPortalTemplate.getStructure().m_230328_((ServerLevelAccessor)destination, (BlockPos)startPos, (BlockPos)startPos, TemplateLoader.STRUCTURE_PLACE_SETTINGS.m_74374_().m_74379_(rotation), destination.f_46441_, 3);
        return !worldBorder.m_61937_((BlockPos)startPos) ? Optional.empty() : Optional.of(new BlockUtil.FoundRectangle(startPos.m_121955_((Vec3i)netherPortalTemplate.getPortalOffset().m_142393_(-1).m_7954_(rotation)), 2, 3));
    }

    private record SkyblockPresetCodec(Codec<WorldPreset> base, Codec<SkyblockPreset> skyblock) implements Codec<WorldPreset>
    {
        public <T> DataResult<T> encode(WorldPreset input, DynamicOps<T> ops, T prefix) {
            if (input instanceof SkyblockPreset) {
                SkyblockPreset skyblockPreset = (SkyblockPreset)input;
                return this.skyblock().encode((Object)skyblockPreset, ops, prefix);
            }
            return this.base().encode((Object)input, ops, prefix);
        }

        public <T> DataResult<Pair<WorldPreset, T>> decode(DynamicOps<T> ops, T input) {
            DataResult skyblockResult = this.skyblock().decode(ops, input);
            if (skyblockResult.result().isPresent()) {
                return skyblockResult;
            }
            return this.base().decode(ops, input);
        }
    }
}

