/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import de.melanx.skyblockbuilder.ModLootItemFunctions;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class SpreadMapFunction
extends LootItemConditionalFunction {
    public static final MapDecoration.Type DEFAULT_DECORATION = MapDecoration.Type.RED_X;
    private final List<String> spreadNames;
    private final MapDecoration.Type mapDecoration;
    private final byte zoom;

    public SpreadMapFunction(LootItemCondition[] predicates, List<String> spreadNames, MapDecoration.Type mapDecoration, byte zoom) {
        super(predicates);
        this.spreadNames = spreadNames;
        this.mapDecoration = mapDecoration;
        this.zoom = zoom;
    }

    @Nonnull
    protected ItemStack m_7372_(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        ServerPlayer player;
        block10: {
            block9: {
                if (!stack.m_150930_(Items.f_42676_)) {
                    return stack;
                }
                Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
                Vec3 pos = (Vec3)context.m_78953_(LootContextParams.f_81460_);
                if (!(entity instanceof ServerPlayer)) break block9;
                player = (ServerPlayer)entity;
                if (pos != null) break block10;
            }
            return stack;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            SkyblockBuilder.getLogger().error("Player {} does not have a team.", (Object)player);
            return stack;
        }
        if (team.getPlacedSpreads().isEmpty()) {
            SkyblockBuilder.getLogger().error("Team {} has no placed spreads", (Object)team.getName());
            return stack;
        }
        HashSet<Team.PlacedSpread> placedSpreads = new HashSet<Team.PlacedSpread>();
        for (String spreadName : this.spreadNames) {
            placedSpreads.addAll(team.getPlacedSpreads(spreadName));
        }
        if (placedSpreads.isEmpty()) {
            SkyblockBuilder.getLogger().error("No spread {} for team {}", this.spreadNames, (Object)team.getName());
            return stack;
        }
        BlockPos middle = SpreadMapFunction.getMiddle(placedSpreads.stream().map(Team.PlacedSpread::pos).collect(Collectors.toSet()));
        middle = middle.m_7918_(0, 0, 0);
        ItemStack map = SpreadMapFunction.createFixedMap((Level)level, middle.m_123341_(), middle.m_123343_(), this.zoom, true, true);
        MapItem.m_42850_((ServerLevel)level, (ItemStack)map);
        int i = 0;
        for (Team.PlacedSpread placedSpread : placedSpreads) {
            MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)placedSpread.pos(), (String)String.valueOf(i++), (MapDecoration.Type)this.mapDecoration);
        }
        return map;
    }

    public static BlockPos getMiddle(Set<BlockPos> blocks) {
        double x = 0.0;
        double z = 0.0;
        for (BlockPos pos : blocks) {
            x += (double)pos.m_123341_();
            z += (double)pos.m_123343_();
        }
        int avgX = (int)(x / (double)blocks.size());
        int avgZ = (int)(z / (double)blocks.size());
        return new BlockPos(avgX, 0, avgZ);
    }

    private static ItemStack createFixedMap(Level level, int levelX, int levelZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack map = Items.f_42573_.m_7968_();
        MapItemSavedData data = new MapItemSavedData(levelX, levelZ, scale, trackingPosition, unlimitedTracking, false, level.m_46472_());
        int freeMapId = level.m_7354_();
        level.m_142325_("map_" + freeMapId, data);
        map.m_41784_().m_128405_("map", freeMapId);
        return map;
    }

    @Nonnull
    public LootItemFunctionType m_7162_() {
        return ModLootItemFunctions.spreadMap;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SpreadMapFunction> {
        public void serialize(@Nonnull JsonObject json, @Nonnull SpreadMapFunction function, @Nonnull JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            if (function.spreadNames.size() > 1) {
                json.addProperty("spreads", function.spreadNames.get(0));
            } else {
                JsonArray spreadNames = new JsonArray();
                for (String name : function.spreadNames) {
                    spreadNames.add((JsonElement)new JsonPrimitive(name));
                }
                json.add("spreads", (JsonElement)spreadNames);
            }
            if (function.mapDecoration != DEFAULT_DECORATION) {
                json.add("decoration", context.serialize((Object)function.mapDecoration.toString().toLowerCase(Locale.ROOT)));
            }
            if (function.zoom != 2) {
                json.addProperty("zoom", (Number)function.zoom);
            }
        }

        @Nonnull
        public SpreadMapFunction deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, @Nonnull LootItemCondition[] conditions) {
            String decoration = json.has("decoration") ? GsonHelper.m_13906_((JsonObject)json, (String)"decoration") : "red_x";
            byte zoom = json.has("zoom") ? (byte)GsonHelper.m_144790_((JsonObject)json, (String)"zoom") : (byte)2;
            MapDecoration.Type mapDecorationType = DEFAULT_DECORATION;
            try {
                mapDecorationType = MapDecoration.Type.valueOf((String)decoration.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                SkyblockBuilder.getLogger().error("Error while parsing loot table decoration entry. Found {}. Defaulting to {}", (Object)decoration, (Object)mapDecorationType);
            }
            ArrayList<String> spreads = new ArrayList<String>();
            if (json.has("spreads")) {
                JsonElement element = json.get("spreads");
                if (element.isJsonArray()) {
                    JsonArray spreadsArray = element.getAsJsonArray();
                    for (JsonElement entry : spreadsArray) {
                        spreads.add(entry.getAsString());
                    }
                } else {
                    spreads.add(element.getAsString());
                }
            } else {
                SkyblockBuilder.getLogger().error("Spread destination is empty");
            }
            return new SpreadMapFunction(conditions, spreads, mapDecorationType, zoom);
        }
    }
}

