/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class SkyMeta {
    private final Set<UUID> previousTeamIds = Sets.newHashSet();
    private final List<UUID> invites = Lists.newArrayList();
    private final SkyblockSavedData data;
    private UUID owner;
    private UUID teamId = SkyblockSavedData.SPAWN_ID;
    private long lastHomeTeleport;
    private long lastSpawnTeleport;
    private long lastVisitTeleport;

    public static SkyMeta get(SkyblockSavedData data, @Nonnull CompoundTag nbt) {
        return new SkyMeta(data, null).load(nbt);
    }

    public SkyMeta(SkyblockSavedData data, UUID owner) {
        this.data = data;
        this.owner = owner;
    }

    @Nonnull
    public UUID getOwner() {
        return this.owner;
    }

    @Nonnull
    public UUID getTeamId() {
        return this.teamId;
    }

    public void setTeamId(@Nonnull UUID id) {
        this.teamId = id;
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public Set<UUID> getPreviousTeamIds() {
        return this.previousTeamIds;
    }

    public void addPreviousTeamId(@Nonnull UUID id) {
        this.previousTeamIds.add(id);
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public List<UUID> getInvites() {
        return this.invites;
    }

    public void addInvite(@Nonnull UUID teamId) {
        this.invites.add(teamId);
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public void removeInvite(@Nonnull UUID teamId) {
        this.invites.remove(teamId);
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public void resetInvites() {
        this.invites.clear();
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public long getLastHomeTeleport() {
        return this.lastHomeTeleport;
    }

    public void setLastHomeTeleport(long gameTime) {
        this.lastHomeTeleport = gameTime;
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public boolean canTeleportHome(long gameTime) {
        return (this.lastHomeTeleport == 0L ? (long)PermissionsConfig.Teleports.homeCooldown : gameTime) - this.getLastHomeTeleport() >= (long)PermissionsConfig.Teleports.homeCooldown;
    }

    public long getLastSpawnTeleport() {
        return this.lastSpawnTeleport;
    }

    public void setLastSpawnTeleport(long gameTime) {
        this.lastSpawnTeleport = gameTime;
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public boolean canTeleportSpawn(long gameTime) {
        return (this.lastSpawnTeleport == 0L ? (long)PermissionsConfig.Teleports.spawnCooldown : gameTime) - this.getLastSpawnTeleport() >= (long)PermissionsConfig.Teleports.spawnCooldown;
    }

    public long getLastVisitTeleport() {
        return this.lastVisitTeleport;
    }

    public void setLastVisitTeleport(long gameTime) {
        this.lastVisitTeleport = gameTime;
        if (this.data != null) {
            this.data.setDirtySilently();
        }
    }

    public boolean canVisit(long gameTime) {
        return (this.lastVisitTeleport == 0L ? (long)PermissionsConfig.Teleports.visitCooldown : gameTime) - this.getLastVisitTeleport() >= (long)PermissionsConfig.Teleports.visitCooldown;
    }

    public SkyMeta load(@Nonnull CompoundTag nbt) {
        this.owner = nbt.m_128342_("OwnerId");
        this.teamId = nbt.m_128342_("TeamId");
        this.previousTeamIds.clear();
        for (Tag tag : nbt.m_128437_("PreviousTeamIds", 11)) {
            this.previousTeamIds.add(NbtUtils.m_129233_((Tag)tag));
        }
        this.invites.clear();
        for (Tag tag : nbt.m_128437_("Invitations", 11)) {
            this.invites.add(NbtUtils.m_129233_((Tag)tag));
        }
        this.lastHomeTeleport = nbt.m_128454_("LastHomeTeleport");
        this.lastSpawnTeleport = nbt.m_128454_("LastSpawnTeleport");
        this.lastVisitTeleport = nbt.m_128454_("LastVisitTeleport");
        return this;
    }

    @Nonnull
    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("OwnerId", this.owner);
        nbt.m_128362_("TeamId", this.teamId);
        ListTag prevTeamIds = new ListTag();
        for (UUID id : this.previousTeamIds) {
            prevTeamIds.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        ListTag invitationTeams = new ListTag();
        for (UUID id : this.invites) {
            invitationTeams.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        nbt.m_128365_("PreviousTeamIds", (Tag)prevTeamIds);
        nbt.m_128365_("Invitations", (Tag)invitationTeams);
        nbt.m_128356_("LastHomeTeleport", this.lastHomeTeleport);
        nbt.m_128356_("LastSpawnTeleport", this.lastSpawnTeleport);
        nbt.m_128356_("LastVisitTeleport", this.lastVisitTeleport);
        return nbt;
    }
}

