/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VisitCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"visit").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.VISIT_TEAMS).executes(context -> VisitCommand.visit((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int visit(CommandSourceStack source, String name) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeam(name);
        if (team == null) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (!player.m_20310_(2) && !data.getOrCreateMetaInfo((Player)player).canVisit(level.m_46467_())) {
            source.m_81352_((Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)PermissionsConfig.Teleports.visitCooldown - (level.m_46467_() - data.getOrCreateMetaInfo((Player)player).getLastVisitTeleport()))}));
            return 0;
        }
        if (!player.m_20310_(2) && !PermissionsConfig.Teleports.teleportationDimensions.test(player.m_9236_().m_46472_().m_135782_())) {
            source.m_81352_((Component)Component.m_237115_((String)"skyblockbuilder.command.error.teleportation_not_allowed_dimension"));
            return 0;
        }
        if (!player.m_20310_(2) && !PermissionsConfig.Teleports.crossDimensionTeleportation && player.m_9236_() != data.getLevel()) {
            source.m_81352_((Component)Component.m_237115_((String)"skyblockbuilder.command.error.teleport_across_dimensions"));
            return 0;
        }
        switch (SkyblockHooks.onVisit(player, team)) {
            case DENY: {
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.disabled.visit_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (team.hasPlayer((Player)player)) {
                    source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.visit_own_team").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                if (player.m_20310_(2)) break;
                if (!PermissionsConfig.Teleports.allowVisits) {
                    source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.disabled.team_visit").m_130940_(ChatFormatting.RED), false);
                    return 0;
                }
                if (team.allowsVisits()) break;
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.disabled.visit_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        WorldUtil.teleportToIsland(player, team);
        data.getOrCreateMetaInfo((Player)player).setLastVisitTeleport(level.m_46467_());
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.visit_team", (Object[])new Object[]{name}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }
}

