/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.util.ToggleButtons;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record ToggleStateButtonClick(UUID team, ToggleButtons.Type type) {

    public static class Serializer
    implements PacketSerializer<ToggleStateButtonClick> {
        public Class<ToggleStateButtonClick> messageClass() {
            return ToggleStateButtonClick.class;
        }

        public void encode(ToggleStateButtonClick msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.team);
            buffer.m_130068_((Enum)msg.type);
        }

        public ToggleStateButtonClick decode(FriendlyByteBuf buffer) {
            return new ToggleStateButtonClick(buffer.m_130259_(), (ToggleButtons.Type)buffer.m_130066_(ToggleButtons.Type.class));
        }
    }

    public static class Handler
    implements PacketHandler<ToggleStateButtonClick> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(ToggleStateButtonClick msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            Level level = player.m_9236_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeam(msg.team);
            if (team != null) {
                switch (msg.type) {
                    case VISITS: {
                        team.setAllowVisit(!team.allowsVisits());
                        break;
                    }
                    case JOIN_REQUEST: {
                        team.setAllowJoinRequest(!team.allowsJoinRequests());
                    }
                }
            }
            return true;
        }
    }
}

