/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record TeleportToTeam(UUID team) {

    public static class Serializer
    implements PacketSerializer<TeleportToTeam> {
        public Class<TeleportToTeam> messageClass() {
            return TeleportToTeam.class;
        }

        public void encode(TeleportToTeam msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.team);
        }

        public TeleportToTeam decode(FriendlyByteBuf buffer) {
            return new TeleportToTeam(buffer.m_130259_());
        }
    }

    public static class Handler
    implements PacketHandler<TeleportToTeam> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(TeleportToTeam msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            Level level = player.m_9236_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeam(msg.team);
            if (team == null) {
                return true;
            }
            if (!player.m_20310_(2) && !PermissionsConfig.Teleports.teleportationDimensions.test(player.m_9236_().m_46472_().m_135782_())) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.teleportation_not_allowed_dimension"));
                return true;
            }
            if (!player.m_20310_(2) && !PermissionsConfig.Teleports.crossDimensionTeleportation && level != data.getLevel()) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.teleport_across_dimensions"));
                return true;
            }
            if (!player.m_20310_(2) && PermissionsConfig.Teleports.preventWhileFalling && player.f_19789_ > 1.0f) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.prevent_while_falling"));
                return true;
            }
            if (team.isSpawn()) {
                if (!player.m_20310_(2) && !PermissionsConfig.Teleports.spawn) {
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyguis.command.disabled.teleport_spawn"));
                    return true;
                }
                if (!player.m_20310_(2) && !data.getOrCreateMetaInfo((Player)player).canTeleportSpawn(level.m_46467_())) {
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.spawnCooldown - (level.m_46467_() - data.getOrCreateMetaInfo((Player)player).getLastSpawnTeleport())))}));
                    return true;
                }
            }
            if (!team.isSpawn()) {
                if (!team.hasPlayer((Player)player)) {
                    return true;
                }
                if (!player.m_20310_(2) && !data.getOrCreateMetaInfo((Player)player).canTeleportHome(level.m_46467_())) {
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)((long)PermissionsConfig.Teleports.spawnCooldown - (level.m_46467_() - data.getOrCreateMetaInfo((Player)player).getLastSpawnTeleport())))}));
                    return true;
                }
                switch (SkyblockHooks.onHome((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.teleport_home"));
                        return true;
                    }
                    case DEFAULT: {
                        if (player.m_20310_(2) || PermissionsConfig.Teleports.home) break;
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.teleport_home"));
                        return true;
                    }
                }
            }
            if (!player.m_20310_(2)) {
                if (team.isSpawn()) {
                    data.getOrCreateMetaInfo((Player)player).setLastSpawnTeleport(level.m_46467_());
                } else {
                    data.getOrCreateMetaInfo((Player)player).setLastHomeTeleport(level.m_46467_());
                }
            }
            WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237119_());
            return true;
        }
    }
}

