/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record RemoveSpawns(Set<BlockPos> positions) {

    public static class Serializer
    implements PacketSerializer<RemoveSpawns> {
        public Class<RemoveSpawns> messageClass() {
            return RemoveSpawns.class;
        }

        public void encode(RemoveSpawns msg, FriendlyByteBuf buffer) {
            buffer.m_130130_(msg.positions.size());
            msg.positions.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130064_(arg_0));
        }

        public RemoveSpawns decode(FriendlyByteBuf buffer) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                positions.add(buffer.m_130135_());
            }
            return new RemoveSpawns(positions);
        }
    }

    public static class Handler
    implements PacketHandler<RemoveSpawns> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(RemoveSpawns msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            ServerLevel level = (ServerLevel)player.m_20193_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED));
                return true;
            }
            if (level != level.m_7654_().m_129880_(SpawnConfig.dimension)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.wrong_position"));
                return true;
            }
            int failedRemovals = 0;
            for (BlockPos pos : msg.positions) {
                Event.Result result = SkyblockHooks.onRemoveSpawn((ServerPlayer)player, (Team)team, (BlockPos)pos);
                switch (result) {
                    case DENY: {
                        ++failedRemovals;
                        break;
                    }
                    case DEFAULT: {
                        if (PermissionsConfig.selfManage && PermissionsConfig.Spawns.modifySpawns || player.m_20310_(2)) break;
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.modify_spawns"));
                        return true;
                    }
                }
                if (team.removePossibleSpawn(pos)) continue;
                ++failedRemovals;
            }
            if (failedRemovals >= msg.positions.size()) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("removed_spawns.failed", new Object[0]));
            }
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)ComponentBuilder.text("removed_spawns", msg.positions.size() - failedRemovals, msg.positions.size()));
            return true;
        }
    }
}

