/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.commands.invitation.InviteCommand;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record InvitePlayers(String teamName, Set<UUID> players) {

    public static class Serializer
    implements PacketSerializer<InvitePlayers> {
        public Class<InvitePlayers> messageClass() {
            return InvitePlayers.class;
        }

        public void encode(InvitePlayers msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.teamName);
            buffer.m_130130_(msg.players.size());
            for (UUID id : msg.players) {
                buffer.m_130077_(id);
            }
        }

        public InvitePlayers decode(FriendlyByteBuf buffer) {
            String teamName = buffer.m_130277_();
            int size = buffer.m_130242_();
            HashSet ids = Sets.newHashSet();
            for (int i = 0; i < size; ++i) {
                ids.add(buffer.m_130259_());
            }
            return new InvitePlayers(teamName, ids);
        }
    }

    public static class Handler
    implements PacketHandler<InvitePlayers> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(InvitePlayers msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            SkyblockSavedData data = SkyblockSavedData.get((Level)player.m_20193_());
            Team team = data.getTeam(msg.teamName);
            EasyNetwork network = SkyGUIs.getNetwork();
            if (team == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist"));
                return true;
            }
            PlayerList playerList = player.m_20194_().m_6846_();
            int i = 0;
            for (UUID id : msg.players) {
                if (data.hasInvites(id) && data.hasInviteFrom(team, id)) continue;
                data.addInvite(team, (Player)player, id);
                ServerPlayer toInvite = playerList.m_11259_(id);
                if (toInvite != null) {
                    MutableComponent invite = Component.m_237110_((String)"skyblockbuilder.command.info.invited_to_team0", (Object[])new Object[]{player.m_5446_().getString(), team.getName()}).m_130940_(ChatFormatting.GOLD);
                    invite.m_7220_((Component)Component.m_237113_((String)("/skyblock accept \"" + team.getName() + "\"")).m_6270_(Style.f_131099_.m_131144_(InviteCommand.COPY_TEXT).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/skyblock accept \"" + team.getName() + "\"")).m_131157_(ChatFormatting.UNDERLINE).m_131157_(ChatFormatting.GOLD)));
                    invite.m_7220_((Component)Component.m_237115_((String)"skyblockbuilder.command.info.invited_to_team1").m_130940_(ChatFormatting.GOLD));
                    toInvite.m_213846_((Component)invite);
                }
                ++i;
            }
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)ComponentBuilder.text("invite_multiple_users", i));
            return true;
        }
    }
}

