/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.base.list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.widget.RenderArea;
import de.melanx.skyguis.client.widget.ScrollbarWidget;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;
import org.moddingx.libx.render.FilterGuiGraphics;
import org.moddingx.libx.screen.Panel;

public abstract class ListScreen<T>
extends BaseScreen {
    protected static final Component SELECT_ALL = ComponentBuilder.text("select_all", new Object[0]);
    protected static final Component UNSELECT_ALL = ComponentBuilder.text("unselect_all", new Object[0]);
    protected static final int ENTRY_HEIGHT = 14;
    private final ScrollbarInfo scrollbarInfo;
    private final RenderAreaInfo renderAreaInfo;
    private final Set<CheckboxTextWidget> widgets = new HashSet<CheckboxTextWidget>();
    protected final List<T> values;
    protected RenderArea renderArea;
    protected ScrollbarWidget scrollbar;
    private final List<Pair<Matrix4f, Consumer<GuiGraphics>>> capturedTooltips = new LinkedList<Pair<Matrix4f, Consumer<GuiGraphics>>>();
    private boolean isCapturingTooltips = false;

    public ListScreen(Component title, Set<T> values, int xSize, int ySize, ScrollbarInfo scrollbarInfo, RenderAreaInfo renderAreaInfo) {
        this(title, values.stream().toList(), xSize, ySize, scrollbarInfo, renderAreaInfo);
    }

    public ListScreen(Component title, List<T> values, int xSize, int ySize, ScrollbarInfo scrollbarInfo, RenderAreaInfo renderAreaInfo) {
        super(title, xSize, ySize);
        this.values = values;
        this.scrollbarInfo = scrollbarInfo;
        this.renderAreaInfo = renderAreaInfo;
    }

    protected void m_7856_() {
        this.widgets.clear();
        this.scrollbar = new ScrollbarWidget(this, this.scrollbarInfo.x, this.scrollbarInfo.y, 12, this.scrollbarInfo.height);
        this.renderArea = (RenderArea)this.m_7787_((GuiEventListener)new RenderArea(this.x(this.renderAreaInfo.x), this.y(this.renderAreaInfo.y), this.renderAreaInfo.width, this.entriesPerPage() * 14, this.xSize - 20, this.values.size() * 14, 14){

            @Override
            public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ListScreen.this.isCapturingTooltips = true;
                guiGraphics.m_280168_().m_85836_();
                super.m_88315_((GuiGraphics)new TooltipCapturingGuiGraphics(guiGraphics), mouseX, mouseY, partialTick);
                guiGraphics.m_280168_().m_85849_();
                ListScreen.this.isCapturingTooltips = false;
                ListScreen.this.capturedTooltips.forEach(pair -> {
                    int x = mouseX - this.getInitX();
                    int y = mouseY - this.getInitY();
                    if (x > 0 && x < this.getRenderWidth() && y > 0 && y < this.getRenderHeight()) {
                        guiGraphics.m_280168_().m_85836_();
                        guiGraphics.m_280168_().m_166856_();
                        guiGraphics.m_280168_().m_252931_((Matrix4f)pair.getLeft());
                        ((Consumer)pair.getRight()).accept(guiGraphics);
                        guiGraphics.m_280168_().m_85849_();
                    }
                });
                ListScreen.this.capturedTooltips.clear();
            }
        });
        this.fillWidgets();
        this.scrollbar.addListener(this.renderArea);
        this.updateScrollbar();
    }

    protected CheckboxTextWidget addCheckboxWidget(CheckboxTextWidget widget) {
        this.widgets.add(widget);
        return widget;
    }

    protected abstract int entriesPerPage();

    protected abstract void fillWidgets();

    public boolean allSelected() {
        for (CheckboxTextWidget widget : this.widgets) {
            if (widget.selected()) continue;
            return false;
        }
        return true;
    }

    public void selectAll() {
        for (CheckboxTextWidget widget : this.widgets) {
            widget.checkbox.f_93822_ = true;
        }
    }

    public void unselectAll() {
        for (CheckboxTextWidget widget : this.widgets) {
            widget.checkbox.f_93822_ = false;
        }
    }

    public Set<T> getSelectedValues() {
        HashSet ids = new HashSet();
        for (CheckboxTextWidget widget : this.widgets) {
            if (!widget.selected()) continue;
            ids.add(widget.getValue());
        }
        return ids;
    }

    @Override
    public void render_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
        this.scrollbar.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderArea.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.scrollbar.m_6375_(mouseX, mouseY, button) || super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.scrollbar.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.scrollbar.m_6348_(mouseX, mouseY, button) || super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollbar.m_6050_(mouseX, mouseY, delta) || super.m_6050_(mouseX, mouseY, delta);
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.values.size() > this.entriesPerPage());
        this.scrollbar.setMaxOffset(this.values.size() - this.entriesPerPage());
    }

    public List<T> getValues() {
        return ImmutableList.copyOf(this.values);
    }

    private void captureTooltip(PoseStack.Pose pose, Consumer<GuiGraphics> action) {
        this.capturedTooltips.add((Pair<Matrix4f, Consumer<GuiGraphics>>)Pair.of((Object)pose.m_252922_(), action));
    }

    public record ScrollbarInfo(int x, int y, int height) {
    }

    public record RenderAreaInfo(int x, int y, int width, int height) {
        public RenderAreaInfo(int x, int y, int width) {
            this(x, y, width, 0);
        }
    }

    protected class CheckboxTextWidget
    extends Panel {
        protected final T value;
        protected final Checkbox checkbox;

        public CheckboxTextWidget(T value, Screen screen, int x, int y, int width, int height, Component text) {
            this(value, screen, x, y, width, height, Lists.newArrayList(), text);
        }

        public CheckboxTextWidget(T value, Screen screen, int x, int y, int width, int height, List<Component> tooltip, Component text) {
            super(x, y, width, height);
            this.value = value;
            this.checkbox = new SizeableCheckbox(0, 0, height, false);
            this.addRenderableWidget((GuiEventListener)this.checkbox);
            TextWidget textWidget = new TextWidget(height + 5, 0, Math.min(width, TextHelper.stringLength((FormattedText)text)), height, text, tooltip);
            this.addRenderableWidget((GuiEventListener)textWidget);
        }

        public T getValue() {
            return this.value;
        }

        public boolean selected() {
            return this.checkbox.m_93840_();
        }
    }

    private class TooltipCapturingGuiGraphics
    extends FilterGuiGraphics {
        public TooltipCapturingGuiGraphics(GuiGraphics parent) {
            super(parent);
        }

        public void m_280153_(@Nonnull Font font, @Nonnull ItemStack stack, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.m_280153_(font, stack, x, y));
            } else {
                super.m_280153_(font, stack, x, y);
            }
        }

        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, @Nonnull ItemStack stack, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.renderTooltip(font, text, component, stack, x, y));
            } else {
                super.renderTooltip(font, text, component, stack, x, y);
            }
        }

        public void m_280677_(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.m_280677_(font, text, component, x, y));
            } else {
                super.m_280677_(font, text, component, x, y);
            }
        }

        public void m_280557_(@Nonnull Font font, @Nonnull Component text, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.m_280557_(font, text, x, y));
            } else {
                super.m_280557_(font, text, x, y);
            }
        }

        public void m_280666_(@Nonnull Font font, @Nonnull List<Component> text, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.m_280666_(font, text, x, y));
            } else {
                super.m_280666_(font, text, x, y);
            }
        }

        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedText> text, int x, int y, @Nonnull ItemStack stack) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.renderComponentTooltip(font, text, x, y, stack));
            } else {
                super.renderComponentTooltip(font, text, x, y, stack);
            }
        }

        public void m_280245_(@Nonnull Font font, @Nonnull List<? extends FormattedCharSequence> text, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.m_280245_(font, text, x, y));
            } else {
                super.m_280245_(font, text, x, y);
            }
        }

        public void m_280547_(@Nonnull Font font, @Nonnull List<FormattedCharSequence> text, @Nonnull ClientTooltipPositioner positioner, int x, int y) {
            if (ListScreen.this.isCapturingTooltips) {
                ListScreen.this.captureTooltip(this.m_280168_().m_85850_(), guiGraphics -> guiGraphics.m_280547_(font, text, positioner, x, y));
            } else {
                super.m_280547_(font, text, positioner, x, y);
            }
        }
    }
}

