/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.container.EternalDensityContainer;
import moze_intel.projecte.gameObjs.container.inventory.EternalDensityInventory;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemEternalDensity
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IItemMode {
    private static final ILangEntry[] modes;

    public GemEternalDensity(Item.Properties props) {
        super(props);
        this.addItemCapability(AlchBagItemCapabilityWrapper::new);
        this.addItemCapability(AlchChestItemCapabilityWrapper::new);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        if (!level.f_46443_ && entity instanceof Player) {
            entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(inv -> GemEternalDensity.condense(stack, inv));
        }
    }

    private static boolean condense(ItemStack gem, IItemHandler inv) {
        long value;
        if (!gem.m_41784_().m_128471_("Active") || ItemPE.getEmc(gem) == Long.MAX_VALUE) {
            return false;
        }
        ItemStack target = GemEternalDensity.getTarget(gem);
        long targetEmc = EMCHelper.getEmcValue(target);
        if (targetEmc == 0L) {
            return false;
        }
        boolean hasChanged = false;
        boolean isWhitelist = ItemHelper.checkItemNBT(gem, "Whitelist");
        List<ItemStack> whitelist = GemEternalDensity.getWhitelist(gem);
        for (int i = 0; i < inv.getSlots(); ++i) {
            long emcValue;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Lazy filtered = Lazy.of(() -> whitelist.stream().anyMatch(s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)));
            if (!stack.m_41753_() && (!isWhitelist || !((Boolean)filtered.get()).booleanValue()) || (emcValue = EMCHelper.getEmcValue(stack)) == 0L || emcValue >= targetEmc || inv.extractItem(i, stack.m_41613_() == 1 ? 1 : stack.m_41613_() / 2, true).m_41619_() || isWhitelist != (Boolean)filtered.get()) continue;
            ItemStack copy = inv.extractItem(i, stack.m_41613_() == 1 ? 1 : stack.m_41613_() / 2, false);
            GemEternalDensity.addToList(gem, copy);
            ItemPE.addEmcToStack(gem, EMCHelper.getEmcValue(copy) * (long)copy.m_41613_());
            hasChanged = true;
            break;
        }
        if ((value = EMCHelper.getEmcValue(target)) == 0L) {
            return hasChanged;
        }
        while (GemEternalDensity.getEmc(gem) >= value) {
            ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)target.m_41777_(), (boolean)false);
            if (!remain.m_41619_()) {
                return false;
            }
            ItemPE.removeEmc(gem, value);
            GemEternalDensity.setItems(gem, new ArrayList<ItemStack>());
            hasChanged = true;
        }
        return hasChanged;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (player.m_36341_()) {
                CompoundTag nbt = stack.m_41784_();
                if (nbt.m_128471_("Active")) {
                    List<ItemStack> items = GemEternalDensity.getItems(stack);
                    if (!items.isEmpty()) {
                        WorldHelper.createLootDrop(items, level, player.m_20185_(), player.m_20186_(), player.m_20189_());
                        GemEternalDensity.setItems(stack, new ArrayList<ItemStack>());
                        ItemPE.setEmc(stack, 0L);
                    }
                    nbt.m_128379_("Active", false);
                } else {
                    nbt.m_128379_("Active", true);
                }
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProvider(hand, stack), buf -> {
                    buf.m_130068_((Enum)hand);
                    buf.writeByte(player.m_150109_().f_35977_);
                });
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private static ItemStack getTarget(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof GemEternalDensity)) {
            PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Invalid gem of eternal density: {}", (Object)stack);
            return ItemStack.f_41583_;
        }
        GemEternalDensity gem = (GemEternalDensity)item;
        byte target = gem.getMode(stack);
        return switch (target) {
            case 0 -> new ItemStack((ItemLike)Items.f_42416_);
            case 1 -> new ItemStack((ItemLike)Items.f_42417_);
            case 2 -> new ItemStack((ItemLike)Items.f_42415_);
            case 3 -> new ItemStack(PEItems.DARK_MATTER);
            case 4 -> new ItemStack(PEItems.RED_MATTER);
            default -> {
                PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Invalid target for gem of eternal density: {}", (Object)target);
                yield ItemStack.f_41583_;
            }
        };
    }

    private static void setItems(ItemStack stack, List<ItemStack> list) {
        ListTag tList = new ListTag();
        for (ItemStack s : list) {
            CompoundTag nbt = new CompoundTag();
            s.m_41739_(nbt);
            tList.add((Object)nbt);
        }
        stack.m_41784_().m_128365_("Consumed", (Tag)tList);
    }

    private static List<ItemStack> getItems(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (stack.m_41782_()) {
            ListTag tList = stack.m_41784_().m_128437_("Consumed", 10);
            for (int i = 0; i < tList.size(); ++i) {
                list.add(ItemStack.m_41712_((CompoundTag)tList.m_128728_(i)));
            }
        }
        return list;
    }

    private static void addToList(ItemStack gem, ItemStack stack) {
        List<ItemStack> list = GemEternalDensity.getItems(gem);
        GemEternalDensity.addToList(list, stack);
        GemEternalDensity.setItems(gem, list);
    }

    private static void addToList(List<ItemStack> list, ItemStack stack) {
        boolean hasFound = false;
        for (ItemStack s : list) {
            if (s.m_41613_() >= s.m_41741_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
            int remain = s.m_41741_() - s.m_41613_();
            if (stack.m_41613_() <= remain) {
                s.m_41769_(stack.m_41613_());
                hasFound = true;
                break;
            }
            s.m_41769_(remain);
            stack.m_41774_(remain);
        }
        if (!hasFound) {
            list.add(stack);
        }
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        if (stack.m_41720_() instanceof GemEternalDensity) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null || !nbt.m_128425_("Consumed", 9)) {
                return nbt;
            }
            return ItemHelper.copyNBTSkipKey(nbt, "Consumed");
        }
        return super.getShareTag(stack);
    }

    private static List<ItemStack> getWhitelist(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41784_().m_128469_("Items");
            ListTag list = compound.m_128437_("Items", 10);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                ItemStack s = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                if (s.m_41619_() || !result.stream().noneMatch(r -> ItemHandlerHelper.canItemStacksStack((ItemStack)r, (ItemStack)s))) continue;
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ILangEntry getModeSwitchEntry() {
        return PELang.DENSITY_MODE_TARGET;
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return modes;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add((Component)PELang.TOOLTIP_GEM_DENSITY_1.translate(new Object[0]));
        if (stack.m_41782_()) {
            tooltips.add((Component)PELang.TOOLTIP_GEM_DENSITY_2.translate(this.getModeLangEntry(stack)));
        }
        tooltips.add((Component)PELang.TOOLTIP_GEM_DENSITY_3.translate(ClientKeyHelper.getKeyName(PEKeybind.MODE)));
        tooltips.add((Component)PELang.TOOLTIP_GEM_DENSITY_4.translate(new Object[0]));
        tooltips.add((Component)PELang.TOOLTIP_GEM_DENSITY_5.translate(new Object[0]));
    }

    @Override
    public boolean updateInAlchChest(@NotNull Level level, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        EmcBlockEntity chest;
        if (!level.f_46443_ && ItemHelper.checkItemNBT(stack, "Active") && (chest = WorldHelper.getBlockEntity(EmcBlockEntity.class, (BlockGetter)level, pos, true)) != null) {
            chest.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                if (GemEternalDensity.condense(stack, inv)) {
                    chest.m_6596_();
                }
            });
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@NotNull IItemHandler inv, @NotNull Player player, @NotNull ItemStack stack) {
        return !player.m_9236_().f_46443_ && GemEternalDensity.condense(stack, inv);
    }

    static {
        ILangEntry[] iLangEntryArray = new ILangEntry[5];
        iLangEntryArray[0] = () -> ((Item)Items.f_42416_).m_5524_();
        iLangEntryArray[1] = () -> ((Item)Items.f_42417_).m_5524_();
        iLangEntryArray[2] = () -> ((Item)Items.f_42415_).m_5524_();
        iLangEntryArray[3] = PEItems.DARK_MATTER::getTranslationKey;
        iLangEntryArray[4] = PEItems.RED_MATTER::getTranslationKey;
        modes = iLangEntryArray;
    }

    private record ContainerProvider(InteractionHand hand, ItemStack stack) implements MenuProvider
    {
        @NotNull
        public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            return new EternalDensityContainer(windowId, playerInventory, this.hand, playerInventory.f_35977_, new EternalDensityInventory(this.stack));
        }

        @NotNull
        public Component m_5446_() {
            return TextComponentUtil.build(PEItems.GEM_OF_ETERNAL_DENSITY.get());
        }
    }
}

