/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.inventory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.event.PlayerAttemptLearnEvent;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TransmutationInventory
extends CombinedInvWrapper {
    public final Player player;
    public final IKnowledgeProvider provider;
    private final IItemHandlerModifiable inputLocks;
    private final IItemHandlerModifiable learning;
    public final IItemHandlerModifiable outputs;
    private static final int LOCK_INDEX = 8;
    private static final int FUEL_START = 12;
    public int learnFlag = 0;
    public int unlearnFlag = 0;
    public String filter = "";
    public int searchpage = 0;
    private List<ItemInfo> knowledge = Collections.emptyList();

    public TransmutationInventory(Player player) {
        super(new IItemHandlerModifiable[]{(IItemHandlerModifiable)((IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new)).getInputAndLocks(), new ItemStackHandler(2), new ItemStackHandler(16)});
        this.player = player;
        this.provider = (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
        this.inputLocks = this.itemHandler[0];
        this.learning = this.itemHandler[1];
        this.outputs = this.itemHandler[2];
        if (!this.isServer()) {
            this.updateClientTargets();
        }
    }

    public boolean isServer() {
        return !this.player.m_9236_().f_46443_;
    }

    public void handleKnowledge(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.handleKnowledge(ItemInfo.fromStack(stack));
        }
    }

    public void handleKnowledge(ItemInfo info) {
        ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
        if (!this.provider.hasKnowledge(cleanedInfo) && !MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptLearnEvent(this.player, info, cleanedInfo)) && this.provider.addKnowledge(cleanedInfo)) {
            this.provider.syncKnowledgeChange((ServerPlayer)this.player, cleanedInfo, true);
        }
    }

    public void itemLearned() {
        this.learnFlag = 300;
        this.unlearnFlag = 0;
        this.updateClientTargets();
    }

    public void handleUnlearn(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.handleUnlearn(ItemInfo.fromStack(stack));
        }
    }

    public void handleUnlearn(ItemInfo info) {
        ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
        if (this.provider.hasKnowledge(cleanedInfo) && this.provider.removeKnowledge(cleanedInfo)) {
            this.provider.syncKnowledgeChange((ServerPlayer)this.player, cleanedInfo, false);
        }
    }

    public void itemUnlearned() {
        this.unlearnFlag = 300;
        this.learnFlag = 0;
        this.updateClientTargets();
    }

    public void checkForUpdates() {
        long fuelEmc;
        long matterEmc = EMCHelper.getEmcValue(this.outputs.getStackInSlot(0));
        if (BigInteger.valueOf(Math.max(matterEmc, fuelEmc = EMCHelper.getEmcValue(this.outputs.getStackInSlot(12)))).compareTo(this.getAvailableEmc()) > 0) {
            this.updateClientTargets();
        }
    }

    public void updateClientTargets() {
        if (this.isServer()) {
            return;
        }
        this.knowledge = this.provider.getKnowledge().stream().filter(EMCHelper::doesItemHaveEmc).sorted(Collections.reverseOrder(Comparator.comparing(EMCHelper::getEmcValue))).collect(Collectors.toList());
        for (int i = 0; i < this.outputs.getSlots(); ++i) {
            this.outputs.setStackInSlot(i, ItemStack.f_41583_);
        }
        int pagecounter = 0;
        int desiredPage = this.searchpage * 12;
        ItemInfo lockInfo = null;
        BigInteger availableEMC = this.getAvailableEmc();
        if (!this.inputLocks.getStackInSlot(8).m_41619_()) {
            lockInfo = NBTManager.getPersistentInfo(ItemInfo.fromStack(this.inputLocks.getStackInSlot(8)));
            long reqEmc = EMCHelper.getEmcValue(lockInfo);
            if (availableEMC.compareTo(BigInteger.valueOf(reqEmc)) < 0) {
                return;
            }
            Iterator<ItemInfo> iter = this.knowledge.iterator();
            while (iter.hasNext()) {
                ItemInfo info = iter.next();
                if (EMCHelper.getEmcValue(info) > reqEmc || info.equals(lockInfo) || !this.doesItemMatchFilter(info)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= desiredPage) continue;
                ++pagecounter;
                iter.remove();
            }
        } else {
            Iterator<ItemInfo> iter = this.knowledge.iterator();
            while (iter.hasNext()) {
                ItemInfo info = iter.next();
                if (availableEMC.compareTo(BigInteger.valueOf(EMCHelper.getEmcValue(info))) < 0 || !this.doesItemMatchFilter(info)) {
                    iter.remove();
                    continue;
                }
                if (pagecounter >= desiredPage) continue;
                ++pagecounter;
                iter.remove();
            }
        }
        int matterCounter = 0;
        int fuelCounter = 0;
        if (lockInfo != null && this.provider.hasKnowledge(lockInfo)) {
            ItemStack lockStack = lockInfo.createStack();
            if (FuelMapper.isStackFuel(lockStack)) {
                this.outputs.setStackInSlot(12, lockStack);
                ++fuelCounter;
            } else {
                this.outputs.setStackInSlot(0, lockStack);
                ++matterCounter;
            }
        }
        for (ItemInfo info : this.knowledge) {
            ItemStack stack = info.createStack();
            if (FuelMapper.isStackFuel(stack)) {
                if (fuelCounter >= 4) continue;
                this.outputs.setStackInSlot(12 + fuelCounter, stack);
                ++fuelCounter;
                continue;
            }
            if (matterCounter >= 12) continue;
            this.outputs.setStackInSlot(matterCounter, stack);
            ++matterCounter;
        }
    }

    private boolean doesItemMatchFilter(ItemInfo info) {
        if (this.filter.isEmpty()) {
            return true;
        }
        try {
            return info.createStack().m_41786_().getString().toLowerCase(Locale.ROOT).contains(this.filter);
        }
        catch (Exception e) {
            PECore.LOGGER.error("Failed to check filter", (Throwable)e);
            return true;
        }
    }

    public void writeIntoOutputSlot(int slot, ItemStack item) {
        long emcValue = EMCHelper.getEmcValue(item);
        if (emcValue > 0L && BigInteger.valueOf(emcValue).compareTo(this.getAvailableEmc()) <= 0 && this.provider.hasKnowledge(item)) {
            this.outputs.setStackInSlot(slot, item);
        } else {
            this.outputs.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    public void addEmc(BigInteger value) {
        int compareToZero = value.compareTo(BigInteger.ZERO);
        if (compareToZero == 0) {
            return;
        }
        if (compareToZero < 0) {
            this.removeEmc(value.negate());
            return;
        }
        ArrayList<Integer> inputLocksChanged = new ArrayList<Integer>();
        for (int slotIndex = 0; slotIndex < this.inputLocks.getSlots(); ++slotIndex) {
            long shrunkenValue;
            IItemEmcHolder emcHolder;
            long actualInserted;
            Optional holderCapability;
            ItemStack stack;
            if (slotIndex == 8 || (stack = this.inputLocks.getStackInSlot(slotIndex)).m_41619_() || !(holderCapability = stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve()).isPresent() || (actualInserted = (emcHolder = (IItemEmcHolder)holderCapability.get()).insertEmc(stack, shrunkenValue = MathUtils.clampToLong(value), IEmcStorage.EmcAction.EXECUTE)) <= 0L) continue;
            inputLocksChanged.add(slotIndex);
            value = value.subtract(BigInteger.valueOf(actualInserted));
            if (value.compareTo(BigInteger.ZERO) != 0) continue;
            this.syncChangedSlots(inputLocksChanged, IKnowledgeProvider.TargetUpdateType.ALL);
            return;
        }
        this.syncChangedSlots(inputLocksChanged, IKnowledgeProvider.TargetUpdateType.NONE);
        this.updateEmcAndSync(this.provider.getEmc().add(value));
    }

    public void removeEmc(BigInteger value) {
        int compareToZero = value.compareTo(BigInteger.ZERO);
        if (compareToZero == 0) {
            return;
        }
        if (compareToZero < 0) {
            this.addEmc(value.negate());
            return;
        }
        BigInteger currentEmc = this.provider.getEmc();
        if (value.compareTo(currentEmc) > 0) {
            ArrayList<Integer> inputLocksChanged = new ArrayList<Integer>();
            BigInteger toRemove = value.subtract(currentEmc);
            value = currentEmc;
            for (int slotIndex = 0; slotIndex < this.inputLocks.getSlots(); ++slotIndex) {
                long shrunkenToRemove;
                IItemEmcHolder emcHolder;
                long actualExtracted;
                Optional holderCapability;
                ItemStack stack;
                if (slotIndex == 8 || (stack = this.inputLocks.getStackInSlot(slotIndex)).m_41619_() || !(holderCapability = stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve()).isPresent() || (actualExtracted = (emcHolder = (IItemEmcHolder)holderCapability.get()).extractEmc(stack, shrunkenToRemove = MathUtils.clampToLong(toRemove), IEmcStorage.EmcAction.EXECUTE)) <= 0L) continue;
                inputLocksChanged.add(slotIndex);
                toRemove = toRemove.subtract(BigInteger.valueOf(actualExtracted));
                if (toRemove.compareTo(BigInteger.ZERO) != 0) continue;
                this.syncChangedSlots(inputLocksChanged, IKnowledgeProvider.TargetUpdateType.IF_NEEDED);
                if (currentEmc.compareTo(BigInteger.ZERO) > 0) {
                    this.updateEmcAndSync(BigInteger.ZERO);
                }
                return;
            }
            this.syncChangedSlots(inputLocksChanged, IKnowledgeProvider.TargetUpdateType.NONE);
        }
        this.updateEmcAndSync(currentEmc.subtract(value));
    }

    public void syncChangedSlots(List<Integer> slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
        this.provider.syncInputAndLocks((ServerPlayer)this.player, slotsChanged, updateTargets);
    }

    private void updateEmcAndSync(BigInteger emc) {
        if (emc.compareTo(BigInteger.ZERO) < 0) {
            emc = BigInteger.ZERO;
        }
        this.provider.setEmc(emc);
        this.provider.syncEmc((ServerPlayer)this.player);
        PlayerHelper.updateScore((ServerPlayer)this.player, PlayerHelper.SCOREBOARD_EMC, emc);
    }

    public IItemHandlerModifiable getHandlerForSlot(int slot) {
        return super.getHandlerFromIndex(super.getIndexForSlot(slot));
    }

    public int getIndexFromSlot(int slot) {
        for (IItemHandlerModifiable h : this.itemHandler) {
            if (slot < h.getSlots()) continue;
            slot -= h.getSlots();
        }
        return slot;
    }

    public BigInteger getAvailableEmc() {
        BigInteger emc = this.provider.getEmc();
        for (int i = 0; i < this.inputLocks.getSlots(); ++i) {
            Optional emcHolder;
            ItemStack stack;
            if (i == 8 || (stack = this.inputLocks.getStackInSlot(i)).m_41619_() || !(emcHolder = stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve()).isPresent()) continue;
            emc = emc.add(BigInteger.valueOf(((IItemEmcHolder)emcHolder.get()).getStoredEmc(stack)));
        }
        return emc;
    }

    public int getKnowledgeSize() {
        return this.knowledge.size();
    }
}

