/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNSSTag<TYPE>
implements NSSTag {
    private static final Set<NSSTag> createdTags = new HashSet<NSSTag>();
    @NotNull
    private final ResourceLocation resourceLocation;
    private final boolean isTag;

    public static Set<NSSTag> getAllCreatedTags() {
        return ImmutableSet.copyOf(createdTags);
    }

    public static void clearCreatedTags() {
        createdTags.clear();
    }

    protected AbstractNSSTag(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        this.resourceLocation = resourceLocation;
        this.isTag = isTag;
        if (isTag) {
            createdTags.add(this);
        }
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    protected abstract boolean isInstance(AbstractNSSTag<?> var1);

    @NotNull
    protected abstract String getType();

    @NotNull
    protected abstract String getJsonPrefix();

    @NotNull
    protected abstract Optional<Either<HolderSet.Named<TYPE>, ITag<TYPE>>> getTag();

    protected final Optional<Either<HolderSet.Named<TYPE>, ITag<TYPE>>> getTag(Registry<TYPE> registry) {
        if (this.representsTag()) {
            return registry.m_203431_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)this.getResourceLocation())).map(Either::left);
        }
        return Optional.empty();
    }

    protected final Optional<Either<HolderSet.Named<TYPE>, ITag<TYPE>>> getTag(IForgeRegistry<? extends TYPE> registry) {
        ITagManager tags;
        if (this.representsTag() && (tags = registry.tags()) != null) {
            return Optional.of(Either.right((Object)tags.getTag(tags.createTagKey(this.getResourceLocation()))));
        }
        return Optional.empty();
    }

    protected abstract Function<TYPE, NormalizedSimpleStack> createNew();

    @Override
    public boolean representsTag() {
        return this.isTag;
    }

    @Override
    public void forEachElement(Consumer<NormalizedSimpleStack> consumer) {
        this.getTag().ifPresent(tag -> ((Stream)tag.map(t -> t.m_203614_().map(Holder::m_203334_), ITag::stream)).map(this.createNew()).forEach(consumer));
    }

    @Override
    public String json() {
        if (this.representsTag()) {
            return this.getJsonPrefix() + "#" + this.getResourceLocation();
        }
        return this.getJsonPrefix() + this.getResourceLocation();
    }

    @Override
    public String toString() {
        if (this.representsTag()) {
            return this.getType() + " Tag: " + this.getResourceLocation();
        }
        return this.getType() + ": " + this.getResourceLocation();
    }

    @Override
    public boolean equals(Object o) {
        AbstractNSSTag other;
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractNSSTag && this.isInstance(other = (AbstractNSSTag)o)) {
            return this.representsTag() == other.representsTag() && this.getResourceLocation().equals((Object)other.getResourceLocation());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.representsTag()) {
            return 31 + this.resourceLocation.hashCode();
        }
        return this.resourceLocation.hashCode();
    }
}

