/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.screen.container;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.tuple.Pair;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.client.screen.container.AbstractTileScreen;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.inventory.AbstractEnergyContainer;
import owmii.powah.network.Network;
import owmii.powah.network.packet.NextEnergyConfigPacket;

public class AbstractEnergyScreen<T extends AbstractEnergyStorage<?, ?>, C extends AbstractEnergyContainer<T>>
extends AbstractTileScreen<T, C> {
    protected IconButton[] configButtons = new IconButton[6];
    protected IconButton configButtonAll = IconButton.EMPTY;

    public AbstractEnergyScreen(C container, Inventory inv, Component title, Texture backGround) {
        super(container, inv, title, backGround);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.hasConfigButtons()) {
            this.addSideConfigButtons(0, 4);
        }
        if (this.hasRedstoneButton()) {
            this.addRedstoneButton(0, 31);
        }
    }

    protected void addSideConfigButtons(int x, int y) {
        for (int i = 0; i < 6; ++i) {
            int id = i;
            Pair<Integer, Integer> offset = this.getSideButtonOffsets(6).get(i);
            int xOffset = (Integer)offset.getLeft();
            int yOffset = (Integer)offset.getRight();
            Direction side = Direction.m_122376_((int)i);
            this.configButtons[i] = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + xOffset + this.f_97726_ + x + 8, this.f_97736_ + yOffset + y + 10, Texture.CONFIG.get((Object)((AbstractEnergyStorage)this.te).getSideConfig().getType(side)), button -> {
                Network.toServer(new NextEnergyConfigPacket(id, ((AbstractEnergyStorage)this.te).m_58899_()));
                ((AbstractEnergyStorage)this.te).getSideConfig().nextType(side);
            }, (Screen)this).setTooltipSupplier(() -> List.of(Component.m_237115_((String)"info.lollipop.facing").m_7220_(Text.COLON).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("info.lollipop.side." + side.m_7912_())).m_130940_(ChatFormatting.DARK_GRAY)), ((AbstractEnergyStorage)this.te).getSideConfig().getType(side).getDisplayName())));
        }
        this.configButtonAll = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_ + x + 14, this.f_97736_ + y + 4, Texture.CONFIG_BTN, button -> {
            Network.toServer(new NextEnergyConfigPacket(6, ((AbstractEnergyStorage)this.te).m_58899_()));
            ((AbstractEnergyStorage)this.te).getSideConfig().nextTypeAll();
        }, (Screen)this).setTooltipSupplier(() -> List.of(Component.m_237115_((String)"info.lollipop.facing").m_7220_(Text.COLON).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"info.lollipop.all").m_130940_(ChatFormatting.DARK_GRAY)), ((AbstractEnergyStorage)this.te).getSideConfig().getType(Direction.UP).getDisplayName())));
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (this.hasConfigButtons()) {
            for (int i = 0; i < 6; ++i) {
                this.configButtons[i].setTexture(Texture.CONFIG.get((Object)((AbstractEnergyStorage)this.te).getSideConfig().getType(Direction.m_122376_((int)i))));
            }
        }
    }

    protected List<Pair<Integer, Integer>> getSideButtonOffsets(int spacing) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)0, (Object)spacing), Pair.of((Object)0, (Object)(-spacing)), Pair.of((Object)0, (Object)0), Pair.of((Object)spacing, (Object)spacing), Pair.of((Object)(-spacing), (Object)0), Pair.of((Object)spacing, (Object)0)});
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.hasConfigButtons()) {
            Texture.CONFIG_BTN_BG.draw(guiGraphics, this.configButtons[1].m_252754_() - 8, this.configButtons[1].m_252907_() - 4);
        }
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        List<Rect2i> extraAreas = super.getExtraAreas();
        if (this.hasConfigButtons()) {
            extraAreas.add(this.toRectangle2d(this.configButtons[1].m_252754_() - 8, this.configButtons[1].m_252907_() - 4, Texture.CONFIG_BTN_BG));
        }
        return extraAreas;
    }

    protected boolean hasConfigButtons() {
        return true;
    }

    protected boolean hasRedstoneButton() {
        return true;
    }
}

