/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.worldgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.oreberriesreplanted.registry.OreBerryPlacementModifiers;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ChanceRangePlacement
extends PlacementModifier {
    public static final Codec<ChanceRangePlacement> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("bottom_offset").orElse((Object)0).forGetter(config -> config.bottomOffset), (App)Codec.INT.fieldOf("top_offset").orElse((Object)0).forGetter(config -> config.topOffset), (App)Codec.INT.fieldOf("maximum").orElse((Object)0).forGetter(config -> config.maximum), (App)Codec.INT.fieldOf("rarity").orElse((Object)0).forGetter(config -> config.rarity)).apply((Applicative)builder, ChanceRangePlacement::new));
    public final int bottomOffset;
    public final int topOffset;
    public final int maximum;
    public final int rarity;

    public ChanceRangePlacement(int bottomOffset, int topOffset, int maximum, int rarity) {
        this.bottomOffset = bottomOffset;
        this.topOffset = topOffset;
        this.maximum = maximum;
        this.rarity = rarity;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        if (random.m_188503_(this.rarity) == 0) {
            int i = pos.m_123341_();
            int j = pos.m_123343_();
            int k = random.m_188503_(this.maximum - this.topOffset) + this.bottomOffset;
            return Stream.of(new BlockPos(i, k, j));
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)OreBerryPlacementModifiers.CAVE_EDGE_RANGE.get();
    }
}

