/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.config;

import com.mrbysco.oreberriesreplanted.OreberriesReplanted;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class OreBerriesConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        OreberriesReplanted.LOGGER.debug("Loaded Oreberries Replanted's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        OreberriesReplanted.LOGGER.warn("Oreberries Replanted's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue growthChance;
        public final ForgeConfigSpec.BooleanValue darknessOnlyIronBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyGoldBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyCopperBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyTinBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyAluminumBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyLeadBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyNickelBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyUraniumBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyOsmiumBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyZincBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlySilverBush;
        public final ForgeConfigSpec.BooleanValue darknessOnlyEssenceBush;
        public final ForgeConfigSpec.IntValue ironBushDensity;
        public final ForgeConfigSpec.IntValue goldBushDensity;
        public final ForgeConfigSpec.IntValue copperBushDensity;
        public final ForgeConfigSpec.IntValue tinBushDensity;
        public final ForgeConfigSpec.IntValue aluminumBushDensity;
        public final ForgeConfigSpec.IntValue leadBushDensity;
        public final ForgeConfigSpec.IntValue nickelBushDensity;
        public final ForgeConfigSpec.IntValue uraniumBushDensity;
        public final ForgeConfigSpec.IntValue osmiumBushDensity;
        public final ForgeConfigSpec.IntValue zincBushDensity;
        public final ForgeConfigSpec.IntValue silverBushDensity;
        public final ForgeConfigSpec.IntValue essenceBushDensity;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.growthChance = builder.comment("Dictates the 1 in X chance the Oreberry Bush grows every time it tries to grow [Default: 20]").defineInRange("growthChance", 20, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Placement settings").push("Placement");
            this.darknessOnlyIronBush = builder.comment("Only allow placing Iron Bushes in darkness [Default: true]").define("darknessOnlyIronBush", true);
            this.darknessOnlyGoldBush = builder.comment("Only allow placing Gold Bushes in darkness [Default: true]").define("darknessOnlyGoldBush", true);
            this.darknessOnlyCopperBush = builder.comment("Only allow placing Copper Bushes in darkness [Default: true]").define("darknessOnlyCopperBush", true);
            this.darknessOnlyTinBush = builder.comment("Only allow placing Tin Bushes in darkness [Default: true]").define("darknessOnlyTinBush", true);
            this.darknessOnlyAluminumBush = builder.comment("Only allow placing Aluminum Bushes in darkness [Default: true]").define("darknessOnlyAluminumBush", true);
            this.darknessOnlyLeadBush = builder.comment("Only allow placing Lead Bushes in darkness [Default: true]").define("darknessOnlyLeadBush", true);
            this.darknessOnlyNickelBush = builder.comment("Only allow placing Nickel Bushes in darkness [Default: true]").define("darknessOnlyNickelBush", true);
            this.darknessOnlyUraniumBush = builder.comment("Only allow placing Uranium Bushes in darkness [Default: true]").define("darknessOnlyUraniumBush", true);
            this.darknessOnlyOsmiumBush = builder.comment("Only allow placing Osmium Bushes in darkness [Default: true]").define("darknessOnlyOsmiumBush", true);
            this.darknessOnlyZincBush = builder.comment("Only allow placing Zinc Bushes in darkness [Default: true]").define("darknessOnlyZincBush", true);
            this.darknessOnlySilverBush = builder.comment("Only allow placing Silver Bushes in darkness [Default: true]").define("darknessOnlySilverBush", true);
            this.darknessOnlyEssenceBush = builder.comment("Only allow placing Essence Bushes in darkness [Default: true]").define("darknessOnlyEssenceBush", true);
            builder.pop();
            builder.comment("Density settings").push("Density");
            this.ironBushDensity = builder.comment("Iron Bush Density [Default: 1]").defineInRange("ironBushDensity", 1, 1, 32);
            this.goldBushDensity = builder.comment("Gold Bush Density [Default: 1]").defineInRange("goldBushDensity", 1, 1, 32);
            this.copperBushDensity = builder.comment("Copper Bush Density [Default: 2]").defineInRange("copperBushDensity", 2, 1, 32);
            this.tinBushDensity = builder.comment("Tin Bush Density [Default: 2]").defineInRange("tinBushDensity", 2, 1, 32);
            this.aluminumBushDensity = builder.comment("Aluminum Bush Density [Default: 2]").defineInRange("aluminumBushDensity", 2, 1, 32);
            this.leadBushDensity = builder.comment("Lead Bush Density [Default: 1]").defineInRange("leadBushDensity", 1, 1, 32);
            this.nickelBushDensity = builder.comment("Nickel Bush Density [Default: 1]").defineInRange("nickelBushDensity", 1, 1, 32);
            this.uraniumBushDensity = builder.comment("Uranium Bush Density [Default: 1]").defineInRange("uraniumBushDensity", 1, 1, 32);
            this.osmiumBushDensity = builder.comment("Osmium Bush Density [Default: 1]").defineInRange("osmiumBushDensity", 1, 1, 32);
            this.zincBushDensity = builder.comment("Zinc Bush Density [Default: 2]").defineInRange("zincBushDensity", 2, 1, 32);
            this.silverBushDensity = builder.comment("Silver Bush Density [Default: 1]").defineInRange("silverBushDensity", 1, 1, 32);
            this.essenceBushDensity = builder.comment("Essence Bush Density [Default: 2]").defineInRange("essenceBushDensity", 2, 1, 32);
            builder.pop();
        }
    }
}

