/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.nckey.mixin;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import committee.nova.nckey.api.ILookup;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.settings.KeyMappingLookup;
import net.minecraftforge.client.settings.KeyModifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={KeyMappingLookup.class})
public class MixinKeyMappingLookup
implements ILookup {
    @Shadow(remap=false)
    @Final
    private static EnumMap<KeyModifier, Map<InputConstants.Key, Collection<KeyMapping>>> map;

    @Override
    public Set<KeyMapping> lookupActives(InputConstants.Key key) {
        Set<KeyMapping> bindings;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(key) && !(bindings = this.getBindings(key, activeModifier)).isEmpty()) {
            return bindings;
        }
        return this.getBindings(key, KeyModifier.NONE);
    }

    @Override
    public Set<KeyMapping> getBindings(InputConstants.Key key, KeyModifier keyModifier) {
        Collection<KeyMapping> bindings = map.get(keyModifier).get(key);
        HashSet toReturn = Sets.newHashSet();
        if (bindings == null) {
            return toReturn;
        }
        for (KeyMapping binding : bindings) {
            if (!binding.isActiveAndMatches(key)) continue;
            toReturn.add(binding);
        }
        return toReturn;
    }
}

