/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.rune;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.register.ModRecipes;
import mythicbotany.rune.SpecialRuneInput;
import mythicbotany.rune.SpecialRuneOutput;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class RuneRitualRecipe
implements Recipe<Container> {
    private static final Map<ResourceLocation, SpecialRuneInput> specialInputs = new HashMap<ResourceLocation, SpecialRuneInput>();
    private static final Map<ResourceLocation, SpecialRuneOutput> specialOutputs = new HashMap<ResourceLocation, SpecialRuneOutput>();
    private final ResourceLocation id;
    private final Ingredient centerRune;
    private final List<RunePosition> runes;
    private final int mana;
    private final int ticks;
    private final List<Ingredient> inputs;
    private final List<ItemStack> outputs;
    @Nullable
    private final SpecialRuneInput specialInput;
    @Nullable
    private final SpecialRuneOutput specialOutput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSpecialInput(SpecialRuneInput action) {
        Map<ResourceLocation, SpecialRuneInput> map = specialInputs;
        synchronized (map) {
            if (specialInputs.containsKey(action.id)) {
                throw new IllegalStateException("Special rune ritual input registered twice: " + action.id);
            }
            specialInputs.put(action.id, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSpecialOutput(SpecialRuneOutput action) {
        Map<ResourceLocation, SpecialRuneOutput> map = specialOutputs;
        synchronized (map) {
            if (specialOutputs.containsKey(action.id)) {
                throw new IllegalStateException("Special rune ritual output registered twice: " + action.id);
            }
            specialOutputs.put(action.id, action);
        }
    }

    public RuneRitualRecipe(ResourceLocation id, Ingredient centerRune, List<RunePosition> runes, int mana, int ticks, List<Ingredient> inputs, List<ItemStack> outputs, @Nullable SpecialRuneInput specialInput, @Nullable SpecialRuneOutput specialOutput) {
        this.id = id;
        this.centerRune = centerRune;
        this.runes = ImmutableList.copyOf(runes);
        this.mana = mana;
        this.ticks = ticks;
        this.inputs = ImmutableList.copyOf(inputs);
        this.outputs = ImmutableList.copyOf(outputs);
        this.specialInput = specialInput;
        this.specialOutput = specialOutput;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return ModRecipes.runeRitual;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem() {
        if (this.outputs.size() == 1) {
            return this.outputs.get(0);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container container, @Nonnull RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public Ingredient getCenterRune() {
        return this.centerRune;
    }

    public List<RunePosition> getRunes() {
        return this.runes;
    }

    public int getMana() {
        return this.mana;
    }

    public int getTicks() {
        return this.ticks;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Nullable
    public SpecialRuneInput getSpecialInput() {
        return this.specialInput;
    }

    @Nullable
    public SpecialRuneOutput getSpecialOutput() {
        return this.specialOutput;
    }

    public static class Serializer
    implements RecipeSerializer<RuneRitualRecipe> {
        public static Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public RuneRitualRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            Ingredient centerRune = Ingredient.m_43917_((JsonElement)json.get("center"));
            ImmutableList.Builder runes = ImmutableList.builder();
            for (JsonElement elem : json.get("runes").getAsJsonArray()) {
                Ingredient rune = Ingredient.m_43917_((JsonElement)elem.getAsJsonObject().get("rune"));
                int x = elem.getAsJsonObject().get("x").getAsInt();
                int z = elem.getAsJsonObject().get("z").getAsInt();
                boolean consume = elem.getAsJsonObject().has("consume") && elem.getAsJsonObject().get("consume").getAsBoolean();
                runes.add((Object)new RunePosition(rune, x, z, consume));
            }
            int mana = json.has("mana") ? json.get("mana").getAsInt() : 0;
            int ticks = json.has("ticks") ? json.get("ticks").getAsInt() : 200;
            ImmutableList.Builder inputs = ImmutableList.builder();
            if (json.has("inputs")) {
                for (JsonElement elem : json.get("inputs").getAsJsonArray()) {
                    inputs.add((Object)Ingredient.m_43917_((JsonElement)elem));
                }
            }
            ImmutableList.Builder outputs = ImmutableList.builder();
            if (json.has("outputs")) {
                for (JsonElement elem : json.get("outputs").getAsJsonArray()) {
                    outputs.add((Object)CraftingHelper.getItemStack((JsonObject)elem.getAsJsonObject(), (boolean)true));
                }
            }
            ResourceLocation specialInputId = json.has("special_input") && !json.get("special_input").isJsonNull() ? new ResourceLocation(json.get("special_input").getAsString()) : null;
            SpecialRuneInput specialInput = null;
            if (specialInputId != null) {
                if (!specialInputs.containsKey(specialInputId)) {
                    throw new IllegalStateException("Unknown special rune input: " + specialInputId);
                }
                specialInput = specialInputs.get(specialInputId);
            }
            ResourceLocation specialOutputId = json.has("special_output") && !json.get("special_output").isJsonNull() ? new ResourceLocation(json.get("special_output").getAsString()) : null;
            SpecialRuneOutput specialOutput = null;
            if (specialOutputId != null) {
                if (!specialOutputs.containsKey(specialOutputId)) {
                    throw new IllegalStateException("Unknown special rune output: " + specialOutputId);
                }
                specialOutput = specialOutputs.get(specialOutputId);
            }
            return new RuneRitualRecipe(recipeId, centerRune, (List<RunePosition>)runes.build(), mana, ticks, (List<Ingredient>)inputs.build(), (List<ItemStack>)outputs.build(), specialInput, specialOutput);
        }

        @Nullable
        public RuneRitualRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient centerRune = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int size = buffer.m_130242_();
            ImmutableList.Builder runes = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                Ingredient rune = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int x = buffer.m_130242_();
                int z = buffer.m_130242_();
                boolean consume = buffer.readBoolean();
                runes.add((Object)new RunePosition(rune, x, z, consume));
            }
            int mana = buffer.m_130242_();
            int ticks = buffer.m_130242_();
            size = buffer.m_130242_();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                inputs.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            size = buffer.m_130242_();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                outputs.add((Object)buffer.m_130267_());
            }
            ResourceLocation specialInputId = null;
            if (buffer.readBoolean()) {
                specialInputId = buffer.m_130281_();
            }
            SpecialRuneInput specialInput = null;
            if (specialInputId != null) {
                if (!specialInputs.containsKey(specialInputId)) {
                    throw new IllegalStateException("Unknown special rune input: " + specialInputId);
                }
                specialInput = specialInputs.get(specialInputId);
            }
            ResourceLocation specialOutputId = null;
            if (buffer.readBoolean()) {
                specialOutputId = buffer.m_130281_();
            }
            SpecialRuneOutput specialOutput = null;
            if (specialOutputId != null) {
                if (!specialOutputs.containsKey(specialOutputId)) {
                    throw new IllegalStateException("Unknown special rune output: " + specialOutputId);
                }
                specialOutput = specialOutputs.get(specialOutputId);
            }
            return new RuneRitualRecipe(recipeId, centerRune, (List<RunePosition>)runes.build(), mana, ticks, (List<Ingredient>)inputs.build(), (List<ItemStack>)outputs.build(), specialInput, specialOutput);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RuneRitualRecipe recipe) {
            recipe.getCenterRune().m_43923_(buffer);
            buffer.m_130130_(recipe.getRunes().size());
            for (RunePosition rune : recipe.getRunes()) {
                rune.getRune().m_43923_(buffer);
                buffer.m_130130_(rune.getX());
                buffer.m_130130_(rune.getZ());
                buffer.writeBoolean(rune.isConsumed());
            }
            buffer.m_130130_(recipe.getMana());
            buffer.m_130130_(recipe.getTicks());
            buffer.m_130130_(recipe.getInputs().size());
            for (Ingredient input : recipe.getInputs()) {
                input.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.getOutputs().size());
            for (ItemStack output : recipe.getOutputs()) {
                buffer.m_130055_(output);
            }
            if (recipe.getSpecialInput() != null) {
                buffer.writeBoolean(true);
                buffer.m_130085_(recipe.getSpecialInput().id);
            } else {
                buffer.writeBoolean(false);
            }
            if (recipe.getSpecialOutput() != null) {
                buffer.writeBoolean(true);
                buffer.m_130085_(recipe.getSpecialOutput().id);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }

    public static class RunePosition {
        private static final int HFLIP = 1;
        private static final int VFLIP = 2;
        private static final int ROTATE = 4;
        private final Ingredient rune;
        private final int x;
        private final int z;
        private final int[] xcoords;
        private final int[] zcoords;
        private final boolean consume;

        public RunePosition(Ingredient rune, int x, int z, boolean consume) {
            this.rune = rune;
            this.x = x;
            this.z = z;
            this.consume = x == 0 && z == 0 || consume;
            this.xcoords = new int[8];
            this.zcoords = new int[8];
            this.xcoords[0] = x;
            this.zcoords[0] = z;
            this.xcoords[1] = -x;
            this.zcoords[1] = z;
            this.xcoords[2] = x;
            this.zcoords[2] = -z;
            this.xcoords[3] = -x;
            this.zcoords[3] = -z;
            for (int i = 0; i < 3; ++i) {
                this.xcoords[i | 4] = -this.zcoords[i];
                this.zcoords[i | 4] = this.xcoords[i];
            }
        }

        public Ingredient getRune() {
            return this.rune;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public boolean isConsumed() {
            return this.consume;
        }

        public int getX(int transformIdx) {
            if (transformIdx < 0 || transformIdx >= 8) {
                return this.getX();
            }
            return this.xcoords[transformIdx];
        }

        public int getZ(int transformIdx) {
            if (transformIdx < 0 || transformIdx >= 8) {
                return this.getZ();
            }
            return this.zcoords[transformIdx];
        }
    }
}

