/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datapack;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datapack.LibXPack;
import org.moddingx.libx.util.lazy.LazyValue;

public class DynamicPackLocator
implements RepositorySource {
    public static final DynamicPackLocator RESOURCE_PACKS = new DynamicPackLocator(PackType.CLIENT_RESOURCES);
    public static final DynamicPackLocator DATA_PACKS = new DynamicPackLocator(PackType.SERVER_DATA);
    private final PackType type;
    private final Set<ResourceLocation> enabledPacks = new HashSet<ResourceLocation>();

    private DynamicPackLocator(PackType type) {
        this.type = type;
    }

    public static void locatePacks(AddPackFindersEvent event) {
        if (PackType.CLIENT_RESOURCES.equals((Object)event.getPackType())) {
            event.addRepositorySource((RepositorySource)RESOURCE_PACKS);
        }
        if (PackType.SERVER_DATA.equals((Object)event.getPackType())) {
            event.addRepositorySource((RepositorySource)DATA_PACKS);
        }
    }

    public synchronized void enablePack(ResourceLocation id) {
        if (!Objects.equals(id.m_135827_(), ModLoadingContext.get().getActiveNamespace())) {
            LibX.logger.error("Wrong modid for dynamic pack, expected " + ModLoadingContext.get().getActiveNamespace() + " got " + id.m_135827_());
        }
        this.enabledPacks.add(id);
    }

    public synchronized boolean isEnabled(ResourceLocation id) {
        return this.enabledPacks.contains(id);
    }

    public void m_7686_(@Nonnull Consumer<Pack> packs) {
        for (ResourceLocation id : this.enabledPacks) {
            String packId = LibXPack.PACK_CONFIG.get(this.type).prefix() + "/" + id.m_135827_() + ":" + id.m_135815_();
            IModFileInfo fileInfo = ModList.get().getModFileById(id.m_135827_());
            if (fileInfo == null || fileInfo.getFile() == null) {
                LibX.logger.warn("Can't create dynamic pack " + id + ": Invalid mod file: " + fileInfo);
                continue;
            }
            LazyValue<LibXPack> resources = new LazyValue<LibXPack>(() -> new LibXPack(fileInfo.getFile(), this.type, id.m_135815_()));
            Pack pack = Pack.m_245429_((String)packId, (Component)Component.m_237113_((String)packId), (boolean)false, anotherId -> (PackResources)resources.get(), (PackType)this.type, (Pack.Position)Pack.Position.BOTTOM, (PackSource)LibXPack.PACK_CONFIG.get(this.type).source());
            if (pack == null) continue;
            packs.accept(pack);
        }
    }
}

