/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.recipe;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;
import org.moddingx.libx.impl.crafting.recipe.EmptyRecipe;
import org.moddingx.libx.mod.ModX;

public abstract class RecipeProviderBase
extends RecipeProvider
implements RecipeExtension {
    protected final ModX mod;
    private Consumer<FinishedRecipe> consumer;

    public RecipeProviderBase(DatagenContext ctx) {
        super(ctx.output());
        this.mod = ctx.mod();
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " recipes";
    }

    protected abstract void setup();

    protected List<ICondition> conditions() {
        return List.of();
    }

    protected final void m_245200_(@Nonnull Consumer<FinishedRecipe> base) {
        List<ICondition> conditions = List.copyOf(this.conditions());
        this.consumer = conditions.isEmpty() ? base : recipe -> {
            if (recipe.m_6637_() == EmptyRecipe.Serializer.INSTANCE) {
                base.accept((FinishedRecipe)recipe);
            } else {
                ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
                conditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)builder).addCondition(arg_0));
                builder.addRecipe(recipe);
                builder.addCondition((ICondition)TrueCondition.INSTANCE);
                builder.addRecipe(EmptyRecipe.empty(recipe.m_6445_()));
                builder.build(base, recipe.m_6445_());
            }
        };
        this.setupExtensions();
        this.setup();
    }

    private void setupExtensions() {
        HashSet collectedClasses = new HashSet();
        ArrayList<Method> extensionMethods = new ArrayList<Method>();
        for (Class<?> currentClass = this.getClass(); currentClass != null && currentClass != RecipeProviderBase.class && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Class<?> iface : currentClass.getInterfaces()) {
                if (!RecipeExtension.class.isAssignableFrom(iface) || !collectedClasses.add(iface)) continue;
                try {
                    Method method = iface.getMethod("setup", ModX.class, iface);
                    if (!Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Recipe extension setup method must be static: " + iface.getName() + "#setup");
                    }
                    extensionMethods.add(method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        for (Method method : extensionMethods) {
            try {
                method.invoke(null, this.mod, this);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't access recipe extension setup method: " + method.getDeclaringClass().getName() + "#setup", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to run recipe extension setup: " + method.getDeclaringClass().getName(), e.getTargetException());
            }
        }
    }

    public ResourceLocation loc(ItemLike item) {
        return new ResourceLocation(this.mod.modid, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_())).m_135815_());
    }

    public ResourceLocation loc(ItemLike item, String suffix) {
        return new ResourceLocation(this.mod.modid, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_())).m_135815_() + "_" + suffix);
    }

    @Override
    public RecipeProviderBase provider() {
        return this;
    }

    @Override
    public Consumer<FinishedRecipe> consumer() {
        return this.consumer;
    }

    public AbstractCriterionTriggerInstance criterion(ItemLike item) {
        return RecipeProviderBase.m_125977_((ItemLike)item);
    }

    public AbstractCriterionTriggerInstance criterion(TagKey<Item> item) {
        return RecipeProviderBase.m_206406_(item);
    }

    public AbstractCriterionTriggerInstance criterion(ItemPredicate ... items) {
        return RecipeProviderBase.m_126011_((ItemPredicate[])items);
    }
}

