/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.StringSplitter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.impl.datagen.load.DatagenFontLoader;

public class PageJson {
    public static JsonElement stack(ItemStack stack) {
        StringBuilder sb = new StringBuilder();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (id == null) {
            throw new IllegalStateException("Item not registered: " + stack);
        }
        sb.append(id.m_135827_());
        sb.append(":");
        sb.append(id.m_135815_());
        if (stack.m_41613_() != 1) {
            sb.append("#");
            sb.append(stack.m_41613_());
        }
        if (stack.m_41782_() && !stack.m_41784_().m_128456_()) {
            sb.append(stack.m_41784_());
        }
        return new JsonPrimitive(sb.toString());
    }

    public static List<String> splitText(String text) {
        return PageJson.splitText(text, false);
    }

    public static List<String> splitText(String text, boolean withInit) {
        return PageJson.splitText(text, withInit ? 14 : 16, 16);
    }

    public static List<String> splitText(String text, int skip) {
        return PageJson.splitText(text, Math.max(16 - skip, 1), 16);
    }

    public static List<String> splitText(String text, int linesHead, int linesTail) {
        Component displayText = PageJson.displayText(text);
        StringSplitter splitter = DatagenFontLoader.getFontMetrics(null);
        List<String> lines = splitter.m_92414_((FormattedText)displayText, Math.round(191.4f), Style.f_131099_).stream().map(FormattedText::getString).map(String::strip).filter(s -> !s.isEmpty()).toList();
        ArrayList<String> pages = new ArrayList<String>();
        boolean first = true;
        while (!lines.isEmpty()) {
            pages.add(lines.stream().limit(first ? (long)linesHead : (long)linesTail).collect(Collectors.joining(" ")));
            lines = lines.stream().skip(first ? (long)linesHead : (long)linesTail).toList();
            first = false;
        }
        return List.copyOf(pages);
    }

    private static Component displayText(String text) {
        Style zeroWidth = Style.f_131099_.m_131150_(DatagenFontLoader.ZERO_WIDTH_FONT);
        MutableComponent display = Component.m_237119_();
        StringBuilder current = new StringBuilder();
        StringBuilder currentFmt = new StringBuilder();
        int idx = 0;
        while (idx < text.length()) {
            if (text.charAt(idx) == '$' && idx + 1 < text.length() && text.charAt(idx + 1) == '(') {
                if (!current.isEmpty()) {
                    display.m_7220_((Component)Component.m_237113_((String)current.toString()).m_6270_(Style.f_131099_));
                    current = new StringBuilder();
                }
                int openCodes = 1;
                currentFmt.append("$(");
                idx += 2;
                while (openCodes > 0 && idx < text.length()) {
                    if (text.charAt(idx) == '$' && idx + 1 < text.length() && text.charAt(idx + 1) == '(') {
                        currentFmt.append("$(");
                        ++openCodes;
                        idx += 2;
                        continue;
                    }
                    if (text.charAt(idx) == ')') {
                        currentFmt.append(")");
                        --openCodes;
                        ++idx;
                        continue;
                    }
                    currentFmt.append(text.charAt(idx));
                    ++idx;
                }
                continue;
            }
            if (!currentFmt.isEmpty()) {
                display.m_7220_((Component)Component.m_237113_((String)currentFmt.toString()).m_6270_(zeroWidth));
                currentFmt = new StringBuilder();
            }
            current.append(text.charAt(idx));
            ++idx;
        }
        if (!current.isEmpty()) {
            display.m_7220_((Component)Component.m_237113_((String)current.toString()).m_6270_(Style.f_131099_));
        }
        if (!currentFmt.isEmpty()) {
            display.m_7220_((Component)Component.m_237113_((String)currentFmt.toString()).m_6270_(zeroWidth));
        }
        return display;
    }
}

