/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.mod.ModX;

public abstract class AdvancementProviderBase
implements DataProvider {
    protected final ModX mod;
    protected final PackTarget packTarget;
    private final Map<ResourceLocation, Supplier<Advancement>> advancements = new HashMap<ResourceLocation, Supplier<Advancement>>();
    private String rootId = null;
    private Supplier<Advancement> rootSupplier = null;

    public AdvancementProviderBase(DatagenContext ctx) {
        this.mod = ctx.mod();
        this.packTarget = ctx.target();
    }

    public abstract void setup();

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " advancements";
    }

    @Nonnull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
        this.setup();
        return CompletableFuture.allOf((CompletableFuture[])this.advancements.values().stream().map(supplier -> {
            Advancement advancement = (Advancement)supplier.get();
            Path path = this.packTarget.path(PackType.SERVER_DATA).resolve(advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public AdvancementFactory root() {
        return this.root(this.mod.modid);
    }

    public AdvancementFactory root(String id) {
        return this.root(this.mod.modid, id);
    }

    public AdvancementFactory root(String namespace, String id) {
        if (id.equals("recipes")) {
            throw new IllegalStateException("Can't 'recipes' as root advancement id. Use a recipe provider to generate recipe advancements.");
        }
        if (this.rootId != null || this.rootSupplier != null) {
            throw new IllegalStateException("Can't use multiple root advancements in the same provider. Use multiple providers for this.");
        }
        if (!this.advancements.isEmpty()) {
            throw new IllegalStateException("The root advancement must be the first advancement that is configured.");
        }
        AdvancementFactory factory = new AdvancementFactory(namespace, id);
        if (this.advancements.put(factory.id, factory::build) != null) {
            throw new IllegalStateException("Duplicate root advancement: " + id);
        }
        this.rootId = id;
        this.rootSupplier = factory::build;
        return factory;
    }

    public void advancement(Advancement advancement) {
        if (this.advancements.put(advancement.m_138327_(), () -> advancement) != null) {
            throw new IllegalStateException("Duplicate advancement: " + advancement.m_138327_());
        }
    }

    public AdvancementFactory advancement(ResourceLocation id) {
        AdvancementFactory factory = new AdvancementFactory(id);
        if (this.advancements.put(id, factory::build) != null) {
            throw new IllegalStateException("Duplicate advancement: " + id);
        }
        return factory;
    }

    public AdvancementFactory advancement(String id) {
        return this.advancement(this.idFor(id));
    }

    public Advancement dummy(ResourceLocation id) {
        return this.dummy(id, false);
    }

    public Advancement dummy(ResourceLocation id, boolean hidden) {
        return new Advancement(id, null, new DisplayInfo(new ItemStack((ItemLike)Items.f_42127_), (Component)Component.m_237119_(), (Component)Component.m_237119_(), null, FrameType.TASK, true, true, hidden), AdvancementRewards.f_9978_, new HashMap(), (String[][])new String[0][], false);
    }

    private ResourceLocation idFor(String id) {
        if (this.rootId == null) {
            throw new IllegalStateException("On advancement providers without a root advancement only fully qualified resource locations are allowed, no plain ids.");
        }
        return this.mod.resource(this.rootId + "/" + id);
    }

    public CriterionTriggerInstance items(ItemLike ... items) {
        return this.items((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()).toArray(ItemPredicate[]::new));
    }

    @SafeVarargs
    public final CriterionTriggerInstance items(TagKey<Item> ... items) {
        return this.items((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.m_45068_().m_204145_(item).m_45077_()).toArray(ItemPredicate[]::new));
    }

    public CriterionTriggerInstance items(ItemPredicate ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])items);
    }

    public TaskFactory itemTasks(ItemLike ... items) {
        return this.itemTasks((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()).toArray(ItemPredicate[]::new));
    }

    @SafeVarargs
    public final TaskFactory itemTasks(TagKey<Item> ... items) {
        return this.itemTasks((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.m_45068_().m_204145_(item).m_45077_()).toArray(ItemPredicate[]::new));
    }

    public TaskFactory itemTasks(ItemPredicate ... items) {
        return () -> (CriterionTriggerInstance[][])Arrays.stream(items).map(item -> new CriterionTriggerInstance[]{this.items((ItemPredicate)item)}).toArray(x$0 -> new CriterionTriggerInstance[x$0][]);
    }

    public CriterionTriggerInstance eat(ItemLike food) {
        return this.eat(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{food}).m_45077_());
    }

    public CriterionTriggerInstance eat(TagKey<Item> food) {
        return this.eat(ItemPredicate.Builder.m_45068_().m_204145_(food).m_45077_());
    }

    public CriterionTriggerInstance eat(ItemPredicate food) {
        return new ConsumeItemTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, food);
    }

    public CriterionTriggerInstance leave(ResourceKey<Level> dimension) {
        return new ChangeDimensionTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, dimension, null);
    }

    public CriterionTriggerInstance enter(ResourceKey<Level> dimension) {
        return ChangeDimensionTrigger.TriggerInstance.m_19782_(dimension);
    }

    public CriterionTriggerInstance changeDim(ResourceKey<Level> from, ResourceKey<Level> to) {
        return new ChangeDimensionTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, from, to);
    }

    public ContextAwarePredicate entity(EntityPredicate entity) {
        return ContextAwarePredicate.m_286108_((LootItemCondition[])new LootItemCondition[]{LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)entity).m_6409_()});
    }

    public ContextAwarePredicate entity(EntityType<?> type) {
        return this.entity(EntityPredicate.Builder.m_36633_().m_36636_(type).m_36662_());
    }

    public ItemPredicate stack(ItemLike item, Enchantment ... enchs) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item});
        for (Enchantment ench : enchs) {
            builder.m_45071_(new EnchantmentPredicate(ench, MinMaxBounds.Ints.m_55386_((int)1)));
        }
        return builder.m_45077_();
    }

    public ItemPredicate stack(TagKey<Item> item, Enchantment ... enchs) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.m_45068_().m_204145_(item);
        for (Enchantment ench : enchs) {
            builder.m_45071_(new EnchantmentPredicate(ench, MinMaxBounds.Ints.m_55386_((int)1)));
        }
        return builder.m_45077_();
    }

    public ItemPredicate stack(Enchantment ... enchs) {
        if (enchs.length == 0) {
            throw new IllegalStateException("Don't use stack() for an any predicate. Use ItemPredicate.ANY instead.");
        }
        ItemPredicate.Builder builder = ItemPredicate.Builder.m_45068_();
        for (Enchantment ench : enchs) {
            builder.m_45071_(new EnchantmentPredicate(ench, MinMaxBounds.Ints.m_55386_((int)1)));
        }
        return builder.m_45077_();
    }

    public ItemPredicate stack(Enchantment ench, int min) {
        return ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(ench, MinMaxBounds.Ints.m_55386_((int)min))).m_45077_();
    }

    public class AdvancementFactory {
        private final ResourceLocation id;
        private final boolean root;
        private Supplier<Advancement> parent;
        private DisplayInfo display;
        private ResourceLocation background;
        private final List<List<Criterion>> criteria = new ArrayList<List<Criterion>>();
        private AdvancementRewards reward = AdvancementRewards.f_9978_;
        private boolean telmetryEvent;

        private AdvancementFactory(String namespace, String rootId) {
            this.id = new ResourceLocation(namespace, rootId + "/root");
            this.root = true;
            this.parent = () -> null;
            this.telmetryEvent = false;
        }

        private AdvancementFactory(ResourceLocation id) {
            this.id = id;
            this.root = false;
            this.parent = () -> null;
        }

        public AdvancementFactory parent(Advancement parent) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            this.parent = () -> parent;
            return this;
        }

        public AdvancementFactory parent(ResourceLocation id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            if (!AdvancementProviderBase.this.advancements.containsKey(id)) {
                throw new IllegalStateException("Parent advancement unknown: " + id);
            }
            this.parent = AdvancementProviderBase.this.advancements.get(id);
            return this;
        }

        public AdvancementFactory parent(String id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            return this.parent(AdvancementProviderBase.this.idFor(id));
        }

        public AdvancementFactory display(ItemLike icon) {
            return this.display(new ItemStack(icon));
        }

        public AdvancementFactory display(ItemLike icon, FrameType frame) {
            return this.display(new ItemStack(icon), frame);
        }

        public AdvancementFactory display(ItemLike icon, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            return this.display(new ItemStack(icon), frame, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemStack icon) {
            return this.display(icon, FrameType.TASK);
        }

        public AdvancementFactory display(ItemStack icon, FrameType frame) {
            return this.display(icon, frame, !this.root, !this.root, false);
        }

        public AdvancementFactory display(ItemStack icon, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            return this.display(icon, (Component)Component.m_237115_((String)("advancements." + this.id.m_135827_() + "." + this.id.m_135815_().replace('/', '.') + ".title")), (Component)Component.m_237115_((String)("advancements." + this.id.m_135827_() + "." + this.id.m_135815_().replace('/', '.') + ".description")), frame, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemLike icon, Component title, Component description) {
            return this.display(new ItemStack(icon), title, description);
        }

        public AdvancementFactory display(ItemLike icon, Component title, Component description, FrameType frame) {
            return this.display(new ItemStack(icon), title, description, frame);
        }

        public AdvancementFactory display(ItemLike icon, Component title, Component description, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            return this.display(new ItemStack(icon), title, description, frame, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemStack icon, Component title, Component description) {
            return this.display(icon, title, description, FrameType.TASK);
        }

        public AdvancementFactory display(ItemStack icon, Component title, Component description, FrameType frame) {
            return this.display(icon, title, description, frame, !this.root, !this.root, false);
        }

        public AdvancementFactory display(ItemStack icon, Component title, Component description, FrameType frame, boolean toast, boolean chat, boolean hidden) {
            this.display = new DisplayInfo(icon, title, description, null, frame, toast, chat, hidden);
            return this;
        }

        public AdvancementFactory background(ResourceLocation background) {
            if (!this.root) {
                throw new IllegalStateException("Can't set background on non-root advancement.");
            }
            this.background = background;
            return this;
        }

        public AdvancementFactory task(CriterionTriggerInstance ... criteria) {
            if (criteria.length == 0) {
                throw new IllegalStateException("Can not add empty task to advancement.");
            }
            this.criteria.add(Arrays.stream(criteria).map(Criterion::new).collect(Collectors.toList()));
            return this;
        }

        public AdvancementFactory tasks(CriterionTriggerInstance ... criteria) {
            if (criteria.length == 0) {
                throw new IllegalStateException("Can not add empty task to advancement.");
            }
            for (CriterionTriggerInstance instance : criteria) {
                this.criteria.add(List.of(new Criterion(instance)));
            }
            this.criteria.add(Arrays.stream(criteria).map(Criterion::new).collect(Collectors.toList()));
            return this;
        }

        public AdvancementFactory tasks(TaskFactory factory) {
            for (CriterionTriggerInstance[] task : factory.apply()) {
                this.task(task);
            }
            return this;
        }

        public AdvancementFactory reward(AdvancementRewards reward) {
            this.reward = reward;
            return this;
        }

        public AdvancementFactory sendsTelmetryEvent() {
            this.telmetryEvent = true;
            return this;
        }

        private Advancement build() {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("Can not add advancement without tasks.");
            }
            HashSet<String> idsTaken = new HashSet<String>();
            String[][] criteriaIds = new String[this.criteria.size()][];
            HashMap<Object, Criterion> criteriaMap = new HashMap<Object, Criterion>();
            for (int i = 0; i < this.criteria.size(); ++i) {
                String[] criterionGroup = new String[this.criteria.get(i).size()];
                for (int j = 0; j < this.criteria.get(i).size(); ++j) {
                    String baseName = Objects.requireNonNull(this.criteria.get(i).get(j).m_11416_(), "Can't build advancement: Empty criterion").m_7294_().m_135815_();
                    baseName = baseName.replace('.', '_').replace('/', '_');
                    Object nextId = baseName;
                    int num = 2;
                    while (idsTaken.contains(nextId)) {
                        nextId = baseName + num++;
                    }
                    idsTaken.add((String)nextId);
                    criterionGroup[j] = nextId;
                    criteriaMap.put(nextId, this.criteria.get(i).get(j));
                }
                criteriaIds[i] = criterionGroup;
            }
            Advancement parentAdv = this.parent.get();
            if (this.root && parentAdv != null) {
                throw new IllegalStateException("Root advancement can not have a parent.");
            }
            if (!this.root && parentAdv == null) {
                if (AdvancementProviderBase.this.rootSupplier != null) {
                    parentAdv = AdvancementProviderBase.this.rootSupplier.get();
                    if (parentAdv == null) {
                        throw new IllegalStateException("Root advancement configured wrongly. This is an error in LibX.");
                    }
                } else {
                    throw new IllegalStateException("This advancement provider has no default root and the advancement " + this.id + " has no root specified.");
                }
            }
            DisplayInfo displayInfo = this.display;
            if (this.root) {
                if (this.display == null) {
                    throw new IllegalStateException("Can't build root advancement without display.");
                }
                if (this.background == null) {
                    throw new IllegalStateException("Can't build root advancement without background.");
                }
                displayInfo = new DisplayInfo(this.display.m_14990_(), this.display.m_14977_(), this.display.m_14985_(), this.background, this.display.m_14992_(), this.display.m_14995_(), this.display.m_14996_(), this.display.m_14997_());
            }
            if (parentAdv != null && parentAdv.m_138320_() == null && displayInfo != null) {
                throw new IllegalStateException("Can't build advancement with display and display-less parent.");
            }
            if (parentAdv != null && parentAdv.m_138320_() != null && displayInfo != null && parentAdv.m_138320_().m_14997_() && !displayInfo.m_14997_()) {
                throw new IllegalStateException("Can't build visible advancement with hidden parent.");
            }
            return new Advancement(this.id, parentAdv, displayInfo, this.reward, criteriaMap, criteriaIds, this.telmetryEvent);
        }
    }

    public static interface TaskFactory {
        public CriterionTriggerInstance[][] apply();
    }
}

