/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.RegistryProvider;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.impl.datagen.InternalDataProvider;
import org.moddingx.libx.impl.datagen.load.DatagenRegistryLoader;
import org.moddingx.libx.impl.datagen.registries.DatagenRegistrySet;
import org.moddingx.libx.impl.datapack.LibXPack;
import org.moddingx.libx.mod.ModX;

public class DatagenSystem {
    private static final Set<ResourceKey<? extends Registry<?>>> EXTENSION_REGISTRIES = new HashSet();
    private final ModX mod;
    private final DataGenerator generator;
    private final ExistingFileHelper fileHelper;
    private final DatagenRegistrySet rootRegistries;
    private final PackTarget mainTarget;
    @Nullable
    private Path resourceRoot;
    private boolean locked;
    private final List<InternalDataProvider.Entry<RegistryProvider>> registryProviders;
    private final List<InternalDataProvider.Entry<RegistryProvider>> extensionProviders;
    private final List<InternalDataProvider.Entry<DataProvider>> dataProviders;

    public static void registerExtensionRegistry(ResourceKey<? extends Registry<?>> registryKey) {
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (!Objects.equals(LibX.getInstance().modid, activeMod) && !Objects.equals(registryKey.m_135782_().m_135827_(), activeMod)) {
            LibX.logger.warn("Registry " + registryKey.m_135782_() + " marked as extension registry by foreign mod: " + activeMod);
        }
        EXTENSION_REGISTRIES.add(registryKey);
    }

    public static Set<ResourceKey<? extends Registry<?>>> extensionRegistries() {
        return Collections.unmodifiableSet(EXTENSION_REGISTRIES);
    }

    public static void create(ModX mod, Consumer<DatagenSystem> configure) {
        if (ModInternal.get(mod).addDatagenConfiguration(configure)) {
            ModInternal.get(mod).modEventBus().addListener(EventPriority.NORMAL, false, GatherDataEvent.class, event -> {
                DatagenSystem system = new DatagenSystem(mod, (GatherDataEvent)event);
                ModInternal.get(mod).configureDatagenSystem(system);
                system.hookIntoGenerator();
            });
        }
    }

    private DatagenSystem(ModX mod, GatherDataEvent event) {
        this.mod = mod;
        this.generator = event.getGenerator();
        this.fileHelper = event.getExistingFileHelper();
        this.rootRegistries = new DatagenRegistrySet((RegistryAccess)DatagenRegistryLoader.loadRegistries(this.fileHelper));
        this.mainTarget = new PackTarget("main", this, new DatagenRegistrySet(List.of(this.rootRegistries)), Map.of(PackType.CLIENT_RESOURCES, this.generator.getPackOutput().m_247566_(PackOutput.Target.RESOURCE_PACK), PackType.SERVER_DATA, this.generator.getPackOutput().m_247566_(PackOutput.Target.DATA_PACK)), null, null, null);
        this.resourceRoot = null;
        this.locked = false;
        this.registryProviders = new ArrayList<InternalDataProvider.Entry<RegistryProvider>>();
        this.extensionProviders = new ArrayList<InternalDataProvider.Entry<RegistryProvider>>();
        this.dataProviders = new ArrayList<InternalDataProvider.Entry<DataProvider>>();
    }

    private void checkNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("Datagen system has already been configured.");
        }
    }

    public ModX mod() {
        return this.mod;
    }

    public ExistingFileHelper fileHelper() {
        return this.fileHelper;
    }

    public PackTarget mainTarget() {
        return this.mainTarget;
    }

    public Path mainOutput() {
        return this.generator.getPackOutput().m_245114_();
    }

    public void setResourceRoot(String root) {
        this.checkNotLocked();
        this.resourceRoot = FMLPaths.GAMEDIR.get().resolve(root);
    }

    public PackTarget nestedDatapack(ResourceLocation id, PackTarget ... parents) {
        return this.makePackTarget(id.toString(), parents).unsupported(PackType.CLIENT_RESOURCES).resolveOutput(PackType.SERVER_DATA, id.m_135827_(), "datapacks", id.m_135815_(), "data").build();
    }

    public PackTarget dynamic(String id, PackType type, PackTarget ... parents) {
        String prefix = LibXPack.PACK_CONFIG.get(type).prefix();
        PackTargetBuilder builder = this.makePackTarget(prefix + "[" + id + "]", parents).setOutput(type, this.mainOutput().resolve(prefix).resolve(id));
        if (this.resourceRoot != null) {
            builder.resources(type, this.resourceRoot.resolve(prefix).resolve(id));
        }
        return builder.build();
    }

    public PackTarget join(PackTarget resources, PackTarget data) {
        PackTargetBuilder builder = this.makePackTarget("[" + resources.name() + "|" + data.name() + "]", resources, data);
        if (resources.outputMap().containsKey(PackType.CLIENT_RESOURCES)) {
            builder.setOutput(PackType.CLIENT_RESOURCES, resources.outputMap().get(PackType.CLIENT_RESOURCES));
        } else {
            builder.unsupported(PackType.CLIENT_RESOURCES);
        }
        if (data.outputMap().containsKey(PackType.SERVER_DATA)) {
            builder.setOutput(PackType.SERVER_DATA, data.outputMap().get(PackType.SERVER_DATA));
        } else {
            builder.unsupported(PackType.SERVER_DATA);
        }
        return builder.build();
    }

    public PackTargetBuilder makePackTarget(String name, PackTarget ... parents) {
        List<DatagenRegistrySet> parentRegistries;
        List<PackTarget> allParents;
        PackTarget mainParent;
        this.checkNotLocked();
        if (parents.length == 0) {
            mainParent = this.mainTarget;
            allParents = List.of(this.mainTarget);
            parentRegistries = List.of((DatagenRegistrySet)this.mainTarget.registries());
        } else {
            mainParent = parents[0];
            allParents = List.of(parents);
            parentRegistries = Arrays.stream(parents).map(parent -> (DatagenRegistrySet)parent.registries()).toList();
        }
        DatagenRegistrySet registries = new DatagenRegistrySet(parentRegistries);
        return new PackTargetBuilder(name, registries, mainParent.outputMap(), allParents);
    }

    public void addRegistryProvider(Function<DatagenContext, RegistryProvider> provider) {
        this.addRegistryProvider(this.mainTarget(), provider);
    }

    public void addRegistryProvider(PackTarget target, Function<DatagenContext, RegistryProvider> provider) {
        this.checkNotLocked();
        this.registryProviders.add(new InternalDataProvider.Entry<RegistryProvider>(target, provider));
    }

    public void addExtensionProvider(Function<DatagenContext, RegistryProvider> provider) {
        this.addExtensionProvider(this.mainTarget(), provider);
    }

    public void addExtensionProvider(PackTarget target, Function<DatagenContext, RegistryProvider> provider) {
        this.checkNotLocked();
        this.extensionProviders.add(new InternalDataProvider.Entry<RegistryProvider>(target, provider));
    }

    public void addDataProvider(Function<DatagenContext, DataProvider> provider) {
        this.addDataProvider(this.mainTarget(), provider);
    }

    public void addDataProvider(PackTarget target, Function<DatagenContext, DataProvider> provider) {
        this.checkNotLocked();
        this.dataProviders.add(new InternalDataProvider.Entry<DataProvider>(target, provider));
    }

    private void hookIntoGenerator() {
        this.locked = true;
        this.generator.addProvider(true, (DataProvider)new InternalDataProvider(this, this.rootRegistries, this.registryProviders, this.extensionProviders, this.dataProviders));
    }

    public class PackTargetBuilder {
        private final String name;
        private final DatagenRegistrySet registries;
        private final Map<PackType, Path> outputMap;
        private final List<PackTarget> parents;
        private final Map<PackType, String> prefixMap;
        private final Map<PackType, List<Path>> resourcePathMap;

        private PackTargetBuilder(String name, DatagenRegistrySet registries, Map<PackType, Path> outputMap, List<PackTarget> parents) {
            this.name = name;
            this.registries = registries;
            this.outputMap = new HashMap<PackType, Path>(outputMap);
            this.parents = parents;
            this.prefixMap = new HashMap<PackType, String>();
            this.resourcePathMap = new HashMap<PackType, List<Path>>();
        }

        public PackTargetBuilder setOutput(PackType type, Path path) {
            this.outputMap.put(type, path);
            this.prefixMap.remove(type);
            return this;
        }

        public PackTargetBuilder resolveOutput(PackType type, String ... subPath) {
            if (!this.outputMap.containsKey(type)) {
                throw new IllegalStateException("Can't resolve output path on pack target that does not support " + type);
            }
            Path path = this.outputMap.get(type);
            for (String pathPart : subPath) {
                path = path.resolve(pathPart);
            }
            this.outputMap.put(type, path);
            this.prefixMap.put(type, String.join((CharSequence)"/", subPath));
            return this;
        }

        public PackTargetBuilder unsupported(PackType type) {
            this.outputMap.remove(type);
            return this;
        }

        public PackTargetBuilder resources(PackType type, Path path) {
            this.resourcePathMap.computeIfAbsent(type, k -> new ArrayList()).add(path);
            return this;
        }

        public PackTarget build() {
            return new PackTarget(this.name, DatagenSystem.this, this.registries, this.outputMap, this.prefixMap, this.resourcePathMap, this.parents);
        }
    }
}

