/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CircuitTableMenu
extends IEContainerMenu {
    private final ItemStackHandler outputInventory = new ItemStackHandler(1);
    public LogicCircuitHandler.LogicCircuitInstruction instruction;
    private final IItemHandler inv;
    public final EnergyStorage energyStorage;

    public static CircuitTableMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, CircuitTableBlockEntity be) {
        return new CircuitTableMenu(CircuitTableMenu.blockCtx(type, id, be), invPlayer, (IItemHandler)new ItemStackHandler(be.getInventory()), be.energyStorage);
    }

    public static CircuitTableMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new CircuitTableMenu(CircuitTableMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(CircuitTableBlockEntity.NUM_SLOTS), new MutableEnergyStorage(32000));
    }

    private CircuitTableMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, MutableEnergyStorage energyStorage) {
        super(ctx);
        int i;
        this.inv = inv;
        this.energyStorage = energyStorage;
        this.m_38897_((Slot)new IESlot.Tagged(inv, this.ownSlotCount++, 8, 14, IETags.circuitPCB));
        this.m_38897_((Slot)new IESlot.Tagged(inv, this.ownSlotCount++, 8, 34, IETags.circuitLogic));
        this.m_38897_((Slot)new IESlot.Tagged(inv, this.ownSlotCount++, 8, 54, IETags.circuitSolder));
        this.m_38897_((Slot)new IESlot.LogicCircuit(inv, this.ownSlotCount++, 175, 11));
        this.m_38897_((Slot)new IESlot.NewOutput((IItemHandler)this.outputInventory, 0, 194, 56){

            public int m_6641_() {
                return 1;
            }

            public void m_142406_(Player player, ItemStack stack) {
                CircuitTableMenu.this.consumeInputs();
                super.m_142406_(player, stack);
            }
        });
        ++this.ownSlotCount;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 143));
        }
        this.addGenericData(GenericContainerData.energy(energyStorage));
    }

    private void consumeInputs() {
        if (this.instruction != null) {
            this.consumeInputs(this.instruction, this.getEditInstruction() != null);
            this.updateOutput();
        }
    }

    private LogicCircuitHandler.LogicCircuitInstruction getEditInstruction() {
        return LogicCircuitBoardItem.getInstruction(this.inv.getStackInSlot(CircuitTableBlockEntity.getEditSlot()));
    }

    public void m_6199_(Container inventory) {
        this.updateOutput();
        super.m_6199_(inventory);
    }

    private void updateOutput() {
        ItemStack newOutput = this.instruction != null && this.canAssemble(this.instruction, this.getEditInstruction() != null) ? LogicCircuitBoardItem.buildCircuitBoard(this.instruction) : ItemStack.f_41583_;
        this.outputInventory.setStackInSlot(0, newOutput);
    }

    public boolean canAssemble(LogicCircuitHandler.LogicCircuitInstruction instruction, boolean editInstruction) {
        if (this.energyStorage.getEnergyStored() < 5000) {
            return false;
        }
        if (editInstruction) {
            return !this.inv.getStackInSlot(CircuitTableBlockEntity.getEditSlot()).m_41619_();
        }
        for (int i = 0; i < CircuitTableBlockEntity.SLOT_TYPES.length; ++i) {
            ItemStack input = this.inv.getStackInSlot(i);
            if (input.m_41613_() >= CircuitTableBlockEntity.getIngredientAmount(instruction, i)) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs(LogicCircuitHandler.LogicCircuitInstruction instruction, boolean editInstruction) {
        this.energyStorage.extractEnergy(5000, false);
        if (editInstruction) {
            this.inv.getStackInSlot(CircuitTableBlockEntity.getEditSlot()).m_41774_(1);
        } else {
            for (int i = 0; i < CircuitTableBlockEntity.SLOT_TYPES.length; ++i) {
                this.inv.getStackInSlot(i).m_41774_(CircuitTableBlockEntity.getIngredientAmount(instruction, i));
            }
        }
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        this.instruction = nbt.m_128441_("operator") ? LogicCircuitHandler.LogicCircuitInstruction.deserialize(nbt) : null;
        this.updateOutput();
    }
}

