/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.split.AbstractSplitModel;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class BakedDynamicSplitModel<K, T extends ICacheKeyProvider<K> & BakedModel>
extends AbstractSplitModel<T> {
    private static final Set<BakedDynamicSplitModel<?, ?>> WEAK_INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    private final LoadingCache<K, Map<Vec3i, List<BakedQuad>>> subModelCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(1L, TimeUnit.MINUTES).build(CacheLoader.from(key -> {
        List<BakedQuad> baseQuads = base.getQuads(key);
        return this.split(baseQuads, parts, transform);
    }));

    public BakedDynamicSplitModel(T base, Set<Vec3i> parts, ModelState transform, @Nonnull Vec3i size) {
        super(base, size);
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        BlockPos offset = (BlockPos)data.get(IEProperties.Model.SUBMODEL_OFFSET);
        if (offset == null) {
            return super.getQuads(state, side, rand, data, renderType);
        }
        Object key = ((ICacheKeyProvider)this.base).getKey(state, side, rand, data, renderType);
        if (key == null) {
            return ImmutableList.of();
        }
        return (List)((Map)this.subModelCache.getUnchecked(key)).getOrDefault(offset, ImmutableList.of());
    }

    static {
        IEApi.renderCacheClearers.add(() -> WEAK_INSTANCES.forEach(m -> m.subModelCache.invalidateAll()));
    }
}

